/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.multiple;

import java.util.List;
import org.apache.isis.core.metamodel.interactions.managed.nonscalar.DataTableModel;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.hints.IsisEnvelopeEvent;
import org.apache.isis.viewer.wicket.model.hints.IsisSelectorEvent;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModelAbstract;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModelHidden;
import org.apache.isis.viewer.wicket.model.util.ComponentHintKey;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.components.collection.count.CollectionCountProvider;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorHelper;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorProvider;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.model.IModel;

public class CollectionContentsMultipleViewsPanel
extends PanelAbstract<DataTableModel, EntityCollectionModel>
implements CollectionCountProvider {
    private static final long serialVersionUID = 1L;
    private static final int MAX_NUM_UNDERLYING_VIEWS = 10;
    private static final String UIHINT_VIEW = "selectedItem";
    private final String underlyingIdPrefix = ComponentType.COLLECTION_CONTENTS.toString();
    private final CollectionSelectorHelper selectorHelper;
    private Component selectedComponent;
    private Component[] underlyingViews;

    public CollectionContentsMultipleViewsPanel(String id, EntityCollectionModel model) {
        super(id, model);
        ComponentHintKey selectedItemSessionAttribute = model.getVariant().isParented() ? ComponentHintKey.create((IsisAppCommonContext)super.getCommonContext(), (Component)this, (String)UIHINT_VIEW) : null;
        this.selectorHelper = new CollectionSelectorHelper(model, this.getComponentFactoryRegistry(), selectedItemSessionAttribute);
    }

    public void onInitialize() {
        super.onInitialize();
        this.addUnderlyingViews();
    }

    private void addUnderlyingViews() {
        EntityCollectionModel visibleCollModel = (EntityCollectionModel)this.getModel();
        EntityCollectionModelHidden hiddenCollModel = EntityCollectionModelHidden.forCollectionModel((EntityCollectionModelAbstract)((EntityCollectionModelAbstract)visibleCollModel));
        List<ComponentFactory> componentFactories = this.selectorHelper.getComponentFactories();
        CollectionSelectorPanel selectorDropdownPanelIfAny = CollectionSelectorProvider.getCollectionSelectorProvider((Component)this);
        String selectedCompFactoryName = selectorDropdownPanelIfAny != null ? this.selectorHelper.honourViewHintElseDefault((Component)selectorDropdownPanelIfAny) : componentFactories.get(0).getName();
        int i = 0;
        int selectedIdx = 0;
        this.underlyingViews = new Component[10];
        for (ComponentFactory componentFactory : componentFactories) {
            String underlyingId = this.underlyingIdPrefix + "-" + i;
            boolean isSelected = selectedCompFactoryName.equals(componentFactory.getName());
            Component underlyingView = componentFactory.createComponent(underlyingId, (IModel<?>)(isSelected ? visibleCollModel : hiddenCollModel));
            if (isSelected) {
                selectedIdx = i;
            }
            this.underlyingViews[i++] = underlyingView;
            this.addOrReplace(new Component[]{underlyingView});
        }
        while (i < 10) {
            String underlyingId = this.underlyingIdPrefix + "-" + i;
            this.permanentlyHide(underlyingId);
            ++i;
        }
        this.setOutputMarkupId(true);
        for (i = 0; i < 10; ++i) {
            Component component = this.underlyingViews[i];
            if (component == null) continue;
            if (i != selectedIdx) {
                PanelAbstract.setVisible(component, false);
                continue;
            }
            this.selectedComponent = component;
        }
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        IsisSelectorEvent selectorEvent = (IsisSelectorEvent)IsisEnvelopeEvent.openLetter(event, IsisSelectorEvent.class);
        if (selectorEvent == null) {
            return;
        }
        CollectionSelectorPanel selectorDropdownPanel = CollectionSelectorProvider.getCollectionSelectorProvider((Component)this);
        if (selectorDropdownPanel == null) {
            return;
        }
        String selectedView = selectorEvent.hintFor((Component)selectorDropdownPanel, UIHINT_VIEW);
        if (selectedView == null) {
            return;
        }
        int underlyingViewNum = this.selectorHelper.lookup(selectedView);
        EntityCollectionModelHidden dummyModel = EntityCollectionModelHidden.forCollectionModel((EntityCollectionModelAbstract)((EntityCollectionModelAbstract)this.getModel()));
        for (int i = 0; i < 10; ++i) {
            Component component = this.underlyingViews[i];
            if (component == null) continue;
            boolean isSelected = i == underlyingViewNum;
            CollectionContentsMultipleViewsPanel.setVisible(component, isSelected);
            component.setDefaultModel((IModel)(isSelected ? this.getModel() : dummyModel));
        }
        this.selectedComponent = this.underlyingViews[underlyingViewNum];
        AjaxRequestTarget target = selectorEvent.getTarget();
        if (target != null) {
            target.add(new Component[]{this, selectorDropdownPanel});
        }
    }

    @Override
    public Integer getCount() {
        if (this.selectedComponent instanceof CollectionCountProvider) {
            CollectionCountProvider collectionCountProvider = (CollectionCountProvider)this.selectedComponent;
            return collectionCountProvider.getCount();
        }
        return null;
    }
}

