/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.summary;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.MixedIn;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.ui.CollectionContentsAsFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.summary.CollectionContentsAsSummary;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.CssResourceReference;

public class CollectionContentsAsSummaryFactory
extends ComponentFactoryAbstract
implements CollectionContentsAsFactory {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "summary";
    static final Predicate<ObjectAssociation> OF_TYPE_BIGDECIMAL = objectAssoc -> {
        ObjectSpecification objectSpec = objectAssoc.getElementType();
        return objectSpec.isValue() && objectSpec.getCorrespondingClass().equals(BigDecimal.class);
    };

    public CollectionContentsAsSummaryFactory() {
        super(ComponentType.COLLECTION_CONTENTS, NAME, CollectionContentsAsSummary.class);
    }

    @Override
    public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
        if (!(model instanceof EntityCollectionModel)) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        EntityCollectionModel entityCollectionModel = (EntityCollectionModel)model;
        ObjectSpecification elementSpec = entityCollectionModel.getElementType();
        Stream associations = elementSpec.streamAssociations(MixedIn.EXCLUDED);
        return this.appliesIf(associations.anyMatch(OF_TYPE_BIGDECIMAL));
    }

    @Override
    public Component createComponent(String id, IModel<?> model) {
        EntityCollectionModel collectionModel = (EntityCollectionModel)model;
        return new CollectionContentsAsSummary(id, collectionModel);
    }

    @Override
    public CssResourceReference getCssResourceReference() {
        return null;
    }

    @Override
    public IModel<String> getTitleLabel() {
        return new ResourceModel("CollectionContentsAsSummaryFactory.Summary", "Summary");
    }

    @Override
    public IModel<String> getCssClass() {
        return Model.of((Serializable)((Object)"fa fa-fw fa-usd"));
    }
}

