/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity;

import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.wicket.model.IModel;

public abstract class EntityComponentFactoryAbstract
extends ComponentFactoryAbstract {
    private static final long serialVersionUID = 1L;

    public EntityComponentFactoryAbstract(ComponentType componentType, Class<?> componentClass) {
        super(componentType, componentClass);
    }

    public EntityComponentFactoryAbstract(ComponentType componentType, String name, Class<?> componentClass) {
        super(componentType, name, componentClass);
    }

    @Override
    protected ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
        if (!(model instanceof EntityModel)) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        EntityModel entityModel = (EntityModel)model;
        ManagedObject adapter = entityModel.getManagedObject();
        if (adapter == null) {
            // empty if block
        }
        ObjectSpecification specification = entityModel.getTypeOfSpecification();
        boolean isScalar = specification.isScalar();
        boolean isValue = specification.containsFacet(ValueFacet.class);
        if (isScalar && !isValue) {
            return this.doAppliesTo(entityModel);
        }
        return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
    }

    protected ComponentFactory.ApplicationAdvice doAppliesTo(EntityModel entityModel) {
        return ComponentFactory.ApplicationAdvice.APPLIES;
    }
}

