/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity.collection;

import java.io.Serializable;
import java.util.List;
import javax.inject.Provider;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModelParented;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.util.ComponentHintKey;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.CollectionPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorHelper;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorPanel;
import org.apache.isis.viewer.wicket.ui.panels.HasDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.Tooltips;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.Model;

public class EntityCollectionPanel
extends PanelAbstract<ManagedObject, EntityModel>
implements HasDynamicallyVisibleContent {
    private static final long serialVersionUID = 1L;
    private static final String ID_COLLECTION_GROUP = "collectionGroup";
    private static final String ID_COLLECTION_NAME = "collectionName";
    private static final String ID_COLLECTION = "collection";
    private static final String ID_ADDITIONAL_LINKS = "additionalLinks";
    private static final String ID_SELECTOR_DROPDOWN = "selectorDropdown";
    private final ComponentHintKey selectedItemHintKey = ComponentHintKey.create((IsisAppCommonContext)super.getCommonContext(), this.getSelectorDropdownPanel(), (String)"selectedItem");
    CollectionSelectorPanel selectorDropdownPanel;
    final WebMarkupContainer div = this.buildGui();
    private boolean visible = false;

    public EntityCollectionPanel(String id, EntityModel entityModel) {
        super(id, entityModel);
    }

    Provider<Component> getSelectorDropdownPanel() {
        return new SelectorDropDownPanelProvider();
    }

    public void onInitialize() {
        super.onInitialize();
        EntityCollectionPanel panel = this;
        if (this.visible) {
            panel.add(new Component[]{this.div});
        } else {
            Components.permanentlyHide((MarkupContainer)panel, this.div.getId());
        }
    }

    private WebMarkupContainer buildGui() {
        WebMarkupContainer div = new WebMarkupContainer(ID_COLLECTION_GROUP);
        EntityCollectionModelParented collectionModel = EntityCollectionModelParented.forParentObjectModel((EntityModel)((EntityModel)this.getModel()));
        div.setMarkupId("collection-" + collectionModel.getLayoutData().getId());
        OneToManyAssociation collectionMetaModel = collectionModel.getMetaModel();
        Wkt.cssAppend(div, collectionModel.getIdentifier());
        Wkt.cssAppend(div, collectionModel.getElementType().getFeatureIdentifier());
        ManagedObject objectAdapter = (ManagedObject)((EntityModel)this.getModel()).getObject();
        Consent visibility = collectionMetaModel.isVisible(objectAdapter, InteractionInitiatedBy.USER, Where.OBJECT_FORMS);
        if (visibility.isAllowed()) {
            this.visible = true;
            collectionMetaModel.lookupFacet(CssClassFacet.class).ifPresent(facet -> Wkt.cssAppend(div, facet.cssClass(objectAdapter)));
            CollectionPanel collectionPanel = this.newCollectionModel(ID_COLLECTION, collectionModel);
            div.addOrReplace(new Component[]{collectionPanel});
            Label labelComponent = collectionPanel.createLabel(ID_COLLECTION_NAME, collectionMetaModel.getFriendlyName(() -> ((EntityCollectionModelParented)collectionModel).getParentObject()));
            labelComponent.setEscapeModelStrings(true);
            div.add(new Component[]{labelComponent});
            collectionMetaModel.getDescription(() -> ((EntityCollectionModelParented)collectionModel).getParentObject()).ifPresent(description -> Tooltips.addTooltip((Component)labelComponent, description));
            Can links = collectionModel.getLinks();
            AdditionalLinksPanel.addAdditionalLinks((MarkupContainer)div, ID_ADDITIONAL_LINKS, (Can<LinkAndLabel>)links, AdditionalLinksPanel.Style.INLINE_LIST);
            CollectionSelectorHelper selectorHelper = new CollectionSelectorHelper((EntityCollectionModel)collectionModel, this.getComponentFactoryRegistry(), this.selectedItemHintKey);
            List<ComponentFactory> componentFactories = selectorHelper.getComponentFactories();
            if (componentFactories.size() <= 1) {
                this.permanentlyHide(ID_SELECTOR_DROPDOWN);
            } else {
                this.selectorDropdownPanel = new CollectionSelectorPanel(ID_SELECTOR_DROPDOWN, (EntityCollectionModel)collectionModel, this.selectedItemHintKey);
                Model componentFactoryModel = new Model();
                String selected = selectorHelper.honourViewHintElseDefault((Component)this.selectorDropdownPanel);
                ComponentFactory selectedComponentFactory = selectorHelper.find(selected);
                componentFactoryModel.setObject((Serializable)selectedComponentFactory);
                this.setOutputMarkupId(true);
                div.addOrReplace(new Component[]{this.selectorDropdownPanel});
                collectionPanel.setSelectorDropdownPanel(this.selectorDropdownPanel);
            }
        }
        return div;
    }

    protected CollectionPanel newCollectionModel(String id, EntityCollectionModelParented entityCollectionModel) {
        return new CollectionPanel(id, entityCollectionModel);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    private class SelectorDropDownPanelProvider
    implements Provider<Component>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private SelectorDropDownPanelProvider() {
        }

        public Component get() {
            return EntityCollectionPanel.this.selectorDropdownPanel;
        }
    }
}

