/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity.icontitle;

import java.util.Optional;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaFactory;
import org.apache.isis.core.metamodel.facets.object.projection.ProjectionFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ObjectAdapterModel;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.Tooltips;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class EntityIconAndTitlePanel
extends PanelAbstract<ManagedObject, ObjectAdapterModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_ENTITY_LINK_WRAPPER = "entityLinkWrapper";
    private static final String ID_ENTITY_FONT_AWESOME = "entityFontAwesome";
    private static final String ID_ENTITY_LINK = "entityLink";
    private static final String ID_ENTITY_TITLE = "entityTitle";
    private static final String ID_ENTITY_ICON = "entityImage";

    public EntityIconAndTitlePanel(String id, ObjectAdapterModel objectAdapterModel) {
        super(id, objectAdapterModel);
        ObjectAdapterModel model = (ObjectAdapterModel)this.getModel();
        ManagedObject obj = (ManagedObject)model.getObject();
        boolean isNonEmptyAbstract = EntityIconAndTitlePanel.isNonEmptyAbstract(obj);
        _Assert.assertFalse((boolean)isNonEmptyAbstract, () -> "model for EntityIconAndTitlePanel, when non-empty, must not represent abstract types");
    }

    protected ManagedObject getTargetAdapter() {
        ManagedObject targetAdapter = ManagedObjects.EntityUtil.refetch((ManagedObject)((ManagedObject)((ObjectAdapterModel)this.getModel()).getObject()));
        return targetAdapter;
    }

    static boolean isNonEmptyAbstract(ManagedObject obj) {
        if (obj == null || obj.getPojo() == null) {
            return false;
        }
        return obj.getSpecification().isAbstract();
    }

    protected void onBeforeRender() {
        this.buildGui();
        super.onBeforeRender();
    }

    private void buildGui() {
        this.addLinkWrapper();
        if (this.isTitleSuppressed()) {
            Wkt.cssAppend(this, "inlinePrompt");
        }
        this.setOutputMarkupId(true);
    }

    private boolean isTitleSuppressed() {
        return ((ObjectAdapterModel)this.getModel()).isInlinePrompt() && !((ObjectAdapterModel)this.getModel()).getRenderingHint().isInTable();
    }

    protected MarkupContainer addLinkWrapper() {
        WebMarkupContainer linkWrapper = Wkt.container(ID_ENTITY_LINK_WRAPPER);
        linkWrapper.addOrReplace(new Component[]{this.createLinkWithIconAndTitle()});
        this.addOrReplace(new Component[]{linkWrapper});
        return linkWrapper;
    }

    private AbstractLink createLinkWithIconAndTitle() {
        ManagedObject targetAdapter = this.getTargetAdapter();
        AbstractLink link = this.createDynamicallyVisibleLink(targetAdapter);
        if (targetAdapter != null) {
            ObjectSpecification spec = targetAdapter.getSpecification();
            String iconName = spec.getIconName(targetAdapter);
            CssClassFaFactory cssClassFaFactory = spec.getCssClassFaFactory().orElse(null);
            if (iconName != null || cssClassFaFactory == null) {
                Wkt.imageAddCachable((MarkupContainer)link, ID_ENTITY_ICON, this.getImageResourceCache().resourceReferenceFor(targetAdapter));
                Components.permanentlyHide((MarkupContainer)link, ID_ENTITY_FONT_AWESOME);
            } else {
                Label dummy = Wkt.labelAdd((MarkupContainer)link, ID_ENTITY_FONT_AWESOME, "");
                Wkt.cssAppend(dummy, cssClassFaFactory.asSpaceSeparatedWithAdditional(new String[]{"fa-2x"}));
                Components.permanentlyHide((MarkupContainer)link, ID_ENTITY_ICON);
            }
            String title = this.determineTitle();
            Wkt.labelAdd((MarkupContainer)link, ID_ENTITY_TITLE, this.titleAbbreviated(title));
            String entityTypeName = this.determineFriendlyType().orElseGet(() -> ((ObjectSpecification)targetAdapter.getSpecification()).getSingularName());
            Tooltips.addTooltip((Component)link, entityTypeName, title);
        }
        return link;
    }

    private AbstractLink createDynamicallyVisibleLink(ManagedObject targetAdapter) {
        final ObjectAdapterModel entityModel = (ObjectAdapterModel)this.getModel();
        PageParameters pageParameters = this.pageParametersFor(targetAdapter);
        Class<? extends Page> pageClass = this.getPageClassRegistry().getPageClass(PageType.ENTITY);
        BookmarkablePageLink<Void> link = new BookmarkablePageLink<Void>(ID_ENTITY_LINK, pageClass, pageParameters){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                ManagedObject targetAdapter = (ManagedObject)entityModel.getObject();
                return targetAdapter != null && (targetAdapter.getPojo() != null || targetAdapter.isBookmarkMemoized());
            }
        };
        return link;
    }

    private PageParameters pageParametersFor(ManagedObject targetAdapter) {
        return ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)targetAdapter) ? ((ObjectAdapterModel)this.getModel()).getPageParametersWithoutUiHints() : EntityModel.ofAdapter((IsisAppCommonContext)super.getCommonContext(), (ManagedObject)targetAdapter.getSpecification().lookupFacet(ProjectionFacet.class).map(projectionFacet -> projectionFacet.projected(targetAdapter)).orElse(targetAdapter)).getPageParametersWithoutUiHints();
    }

    private String titleAbbreviated(String titleString) {
        int maxTitleLength = this.abbreviateTo((ObjectAdapterModel)this.getModel(), titleString);
        return EntityIconAndTitlePanel.abbreviated(titleString, maxTitleLength);
    }

    private Optional<String> determineFriendlyType() {
        ManagedObject domainObject = (ManagedObject)((ObjectAdapterModel)this.getModel()).getObject();
        return ManagedObjects.isSpecified((ManagedObject)domainObject) ? _Strings.nonEmpty((CharSequence)domainObject.getSpecification().getSingularName()) : Optional.empty();
    }

    private String determineTitle() {
        ManagedObject managedObject = (ManagedObject)((ObjectAdapterModel)this.getModel()).getObject();
        return managedObject != null ? managedObject.titleString(conf -> conf.skipTitlePartEvaluator(this::isContextAdapter)) : "(no object)";
    }

    private int abbreviateTo(ObjectAdapterModel model, String titleString) {
        if (model.getRenderingHint().isInStandaloneTableTitleColumn()) {
            return this.getWicketViewerSettings().getMaxTitleLengthInStandaloneTables();
        }
        if (model.getRenderingHint().isInParentedTableTitleColumn()) {
            return this.getWicketViewerSettings().getMaxTitleLengthInParentedTables();
        }
        return titleString.length();
    }

    private boolean isContextAdapter(ManagedObject other) {
        return ((ObjectAdapterModel)this.getModel()).isContextAdapter(other);
    }

    static String abbreviated(String str, int maxLength) {
        int length = str.length();
        if (length <= maxLength) {
            return str;
        }
        return maxLength <= 3 ? "" : str.substring(0, maxLength - 3) + "...";
    }
}

