/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.footer;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.core.config.viewer.web.WebAppContextPath;
import org.apache.isis.viewer.wicket.ui.components.footer.CreditImage;
import org.apache.isis.viewer.wicket.ui.components.footer.CreditName;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbPanel;
import org.apache.isis.viewer.wicket.ui.components.widgets.themepicker.ThemeChooser;
import org.apache.isis.viewer.wicket.ui.pages.about.AboutPage;
import org.apache.isis.viewer.wicket.ui.pages.home.HomePage;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class FooterPanel
extends PanelAbstract<String, Model<String>> {
    private static final long serialVersionUID = 1L;
    private static final String ID_BREADCRUMBS = "breadcrumbs";
    private static final String ID_ABOUT_LINK = "aboutLink";
    private static final String ID_ABOUT_MESSAGE = "aboutMessage";
    private static final String ID_THEME_PICKER = "themePicker";

    public FooterPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.addBreadcrumbs();
        this.addCredits();
        this.addAboutLink();
        this.addThemePicker();
    }

    private void addCredits() {
        List credits = super.getConfiguration().getViewer().getWicket().getCredit();
        boolean hasAnyCredits = !_NullSafe.isEmpty((Collection)credits);
        RepeatingView creditItems = new RepeatingView("creditItems");
        this.add(new Component[]{creditItems});
        if (hasAnyCredits) {
            WebAppContextPath webAppContextPath = super.getWebAppContextPath();
            _NullSafe.stream((Collection)credits).forEach(credit -> {
                WebMarkupContainer listItem = new WebMarkupContainer(creditItems.newChildId());
                creditItems.add(new Component[]{listItem});
                WebMarkupContainer creditLink = this.newCreditLinkComponent((IsisConfiguration.Viewer.Wicket.Credit)credit);
                listItem.add(new Component[]{creditLink});
                String imageUrl = webAppContextPath.prependContextPathIfLocal(credit.getImage());
                creditLink.add(new Component[]{new CreditImage("creditImage", imageUrl)});
                creditLink.add(new Component[]{new CreditName("creditName", credit.getName())});
            });
        }
        Label creditsLabel = Wkt.labelAdd((MarkupContainer)this, "creditsLabel", "Credits: ");
        creditsLabel.setVisibilityAllowed(hasAnyCredits);
    }

    private WebMarkupContainer newCreditLinkComponent(IsisConfiguration.Viewer.Wicket.Credit credit) {
        String creditLinkId = "creditLink";
        ExternalLink creditLink = credit.getUrl() != null ? new ExternalLink("creditLink", credit.getUrl()){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("target", (CharSequence)"_blank");
            }
        } : new BookmarkablePageLink("creditLink", HomePage.class);
        return creditLink;
    }

    private void addBreadcrumbs() {
        boolean showBreadcrumbs = this.getConfiguration().getViewer().getWicket().getBookmarkedPages().isShowDropDownOnFooter();
        BreadcrumbPanel breadcrumbPanel = showBreadcrumbs ? new BreadcrumbPanel(ID_BREADCRUMBS) : new EmptyPanel(ID_BREADCRUMBS).setVisible(false);
        this.addOrReplace(new Component[]{breadcrumbPanel});
    }

    protected void onConfigure() {
        super.onConfigure();
        boolean showFooter = this.getConfiguration().getViewer().getWicket().isShowFooter();
        if (!showFooter) {
            this.setVisible(false);
            return;
        }
        PageParameters parameters = this.getPage().getPageParameters();
        this.setVisible(parameters.get("isis.no.footer").isNull());
    }

    private void addAboutLink() {
        BookmarkablePageLink aboutLink = new BookmarkablePageLink(ID_ABOUT_LINK, AboutPage.class);
        this.add(new Component[]{aboutLink});
        String applicationVersion = this.getIsisConfiguration().getViewer().getWicket().getApplication().getVersion();
        Wkt.labelAdd((MarkupContainer)aboutLink, ID_ABOUT_MESSAGE, (IModel<String>)(_Strings.isNotEmpty((CharSequence)applicationVersion) ? Model.of((Serializable)((Object)applicationVersion)) : new ResourceModel("aboutLabel")));
        this.addDevModeWarning((MarkupContainer)aboutLink);
    }

    private void addDevModeWarning(MarkupContainer container) {
        WebComponent devModeWarning = new WebComponent("devModeWarning");
        devModeWarning.setVisible(this.getApplication().usesDevelopmentConfig());
        container.add(new Component[]{devModeWarning});
    }

    private void addThemePicker() {
        ThemeChooser themeChooser = new ThemeChooser(ID_THEME_PICKER);
        this.addOrReplace(new Component[]{themeChooser});
    }
}

