/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.layout.bs3;

import java.util.Optional;
import org.apache.isis.applib.layout.grid.Grid;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Grid;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Row;
import org.apache.isis.core.metamodel.facets.object.grid.GridFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionMixedIn;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.row.Row;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.markup.repeater.RepeatingView;

public class BS3GridPanel
extends PanelAbstract<ManagedObject, EntityModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_ROWS = "rows";
    private final BS3Grid bs3Page;

    public static Optional<BS3GridPanel> extraContentForMixin(String id, ActionModel actionModel) {
        ObjectActionMixedIn actionMixedIn;
        ObjectSpecification mixinSpec;
        ObjectAction action = actionModel.getAction();
        if (action instanceof ObjectActionMixedIn && (mixinSpec = (actionMixedIn = (ObjectActionMixedIn)action).getMixinType()).isViewModel()) {
            IsisAppCommonContext commonContext = actionModel.getCommonContext();
            ManagedObject targetAdapterForMixin = action.realTargetAdapter(actionModel.getActionOwner());
            GridFacet gridFacet = (GridFacet)mixinSpec.getFacet(GridFacet.class);
            Grid gridForMixin = gridFacet.getGrid(targetAdapterForMixin);
            if (gridForMixin instanceof BS3Grid) {
                BS3Grid bs3Grid = (BS3Grid)gridForMixin;
                EntityModel entityModelForMixin = EntityModel.ofAdapter((IsisAppCommonContext)commonContext, (ManagedObject)targetAdapterForMixin);
                return Optional.of(new BS3GridPanel(id, entityModelForMixin, bs3Grid));
            }
        }
        return Optional.empty();
    }

    public BS3GridPanel(String id, EntityModel entityModel, BS3Grid bs3Grid) {
        super(id, entityModel);
        this.bs3Page = bs3Grid;
        this.buildGui();
    }

    private void buildGui() {
        Wkt.cssAppend(this, this.bs3Page.getCssClass());
        RepeatingView rv = new RepeatingView(ID_ROWS);
        for (BS3Row bs3Row : this.bs3Page.getRows()) {
            String id = rv.newChildId();
            Row row = new Row(id, (EntityModel)this.getModel(), bs3Row);
            rv.add(new Component[]{row});
        }
        this.add(new Component[]{rv});
    }
}

