/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.layout.bs3.col;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.applib.layout.component.DomainObjectLayoutData;
import org.apache.isis.applib.layout.component.FieldSet;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Col;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Row;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Tab;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3TabGroup;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.LinkAndLabelFactory;
import org.apache.isis.viewer.wicket.ui.components.entity.fieldset.PropertyGroup;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.col.RepeatingViewWithDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.row.Row;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.tabs.TabGroupPanel;
import org.apache.isis.viewer.wicket.ui.panels.HasDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public class Col
extends PanelAbstract<ManagedObject, EntityModel>
implements HasDynamicallyVisibleContent {
    private static final long serialVersionUID = 1L;
    private static final String ID_COL = "col";
    private static final String ID_ENTITY_HEADER_PANEL = "entityHeaderPanel";
    private static final String ID_ROWS = "rows";
    private static final String ID_TAB_GROUPS = "tabGroups";
    private static final String ID_FIELD_SETS = "fieldSets";
    private static final String ID_COLLECTIONS = "collections";
    private final BS3Col bs3Col;
    private boolean visible = false;

    public Col(String id, EntityModel entityModel, BS3Col bs3Col) {
        super(id, entityModel);
        this.bs3Col = bs3Col;
        this.buildGui();
    }

    private void buildGui() {
        ArrayList rows;
        String actionIdToHide;
        String actionIdToUse;
        WebMarkupContainer actionOwner;
        this.setRenderBodyOnly(true);
        if (this.bs3Col.getSpan() == 0) {
            Components.permanentlyHide((MarkupContainer)this, ID_COL);
            return;
        }
        WebMarkupContainer div = new WebMarkupContainer(ID_COL);
        Wkt.cssAppend(div, this.bs3Col.toCssClass());
        DomainObjectLayoutData domainObject = this.bs3Col.getDomainObject();
        if (domainObject != null) {
            WebMarkupContainer entityHeaderPanel = new WebMarkupContainer(ID_ENTITY_HEADER_PANEL);
            div.add(new Component[]{entityHeaderPanel});
            ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(ComponentType.ENTITY_ICON_TITLE_AND_COPYLINK, (IModel<?>)this.getModel());
            Component component = componentFactory.createComponent((IModel<?>)this.getModel());
            entityHeaderPanel.addOrReplace(new Component[]{component});
            actionOwner = entityHeaderPanel;
            actionIdToUse = "entityActions";
            actionIdToHide = "actions";
            this.visible = true;
        } else {
            Components.permanentlyHide((MarkupContainer)div, ID_ENTITY_HEADER_PANEL);
            actionOwner = div;
            actionIdToUse = "actions";
            actionIdToHide = null;
        }
        List actionLayoutDataList = this.bs3Col.getActions();
        Can visibleActions = (Can)_NullSafe.stream((Collection)actionLayoutDataList).filter(actionLayoutData -> actionLayoutData.getMetadataError() == null).filter(_NullSafe::isPresent).map(actionLayoutData -> ((EntityModel)this.getModel()).getTypeOfSpecification().getAction(actionLayoutData.getId()).orElse(null)).filter(_NullSafe::isPresent).map(LinkAndLabelFactory.forEntity((EntityModel)this.getModel())).collect(Can.toCan());
        if (!visibleActions.isEmpty()) {
            AdditionalLinksPanel.addAdditionalLinks((MarkupContainer)actionOwner, actionIdToUse, (Can<LinkAndLabel>)visibleActions, AdditionalLinksPanel.Style.INLINE_LIST);
            this.visible = true;
        } else {
            Components.permanentlyHide((MarkupContainer)actionOwner, actionIdToUse);
        }
        if (actionIdToHide != null) {
            Components.permanentlyHide((MarkupContainer)div, actionIdToHide);
        }
        if (!(rows = _Lists.newArrayList((Collection)this.bs3Col.getRows())).isEmpty()) {
            RepeatingViewWithDynamicallyVisibleContent rowsRv = this.buildRows(ID_ROWS, rows);
            div.add(new Component[]{rowsRv});
            this.visible = this.visible || rowsRv.isVisible();
        } else {
            Components.permanentlyHide((MarkupContainer)div, ID_ROWS);
        }
        List tabGroupsWithNonEmptyTabs = _NullSafe.stream((Collection)this.bs3Col.getTabGroups()).filter(_NullSafe::isPresent).filter(bs3TabGroup -> _NullSafe.stream((Collection)bs3TabGroup.getTabs()).anyMatch(BS3Tab.Predicates.notEmpty())).collect(Collectors.toList());
        if (!tabGroupsWithNonEmptyTabs.isEmpty()) {
            RepeatingViewWithDynamicallyVisibleContent tabGroupRv = new RepeatingViewWithDynamicallyVisibleContent(ID_TAB_GROUPS);
            block4: for (Object bs3TabGroup2 : tabGroupsWithNonEmptyTabs) {
                String id = tabGroupRv.newChildId();
                List tabs = _NullSafe.stream((Collection)bs3TabGroup2.getTabs()).filter(BS3Tab.Predicates.notEmpty()).collect(Collectors.toList());
                switch (tabs.size()) {
                    case 0: {
                        throw new IllegalStateException("Cannot render tabGroup with no tabs");
                    }
                    case 1: {
                        if (bs3TabGroup2.isCollapseIfOne() != null && !bs3TabGroup2.isCollapseIfOne().booleanValue()) break;
                        BS3Tab bs3Tab = (BS3Tab)tabs.get(0);
                        List tabRows = bs3Tab.getRows();
                        RepeatingViewWithDynamicallyVisibleContent rowsRv = this.buildRows(id, tabRows);
                        tabGroupRv.add(new Component[]{rowsRv});
                        continue block4;
                    }
                }
                TabGroupPanel tabGroup = new TabGroupPanel(id, (EntityModel)this.getModel(), (BS3TabGroup)bs3TabGroup2);
                tabGroupRv.add(new Component[]{tabGroup});
            }
            div.add(new Component[]{tabGroupRv});
            this.visible = this.visible || tabGroupRv.isVisible();
        } else {
            Components.permanentlyHide((MarkupContainer)div, ID_TAB_GROUPS);
        }
        List fieldSetsWithProperties = _NullSafe.stream((Collection)this.bs3Col.getFieldSets()).filter(_NullSafe::isPresent).filter(fieldSet -> !_NullSafe.isEmpty((Collection)fieldSet.getProperties())).collect(Collectors.toList());
        if (!fieldSetsWithProperties.isEmpty()) {
            RepeatingViewWithDynamicallyVisibleContent fieldSetRv = new RepeatingViewWithDynamicallyVisibleContent(ID_FIELD_SETS);
            for (FieldSet fieldSet2 : fieldSetsWithProperties) {
                String id = fieldSetRv.newChildId();
                PropertyGroup propertyGroup = new PropertyGroup(id, (EntityModel)this.getModel(), fieldSet2);
                fieldSetRv.add(new Component[]{propertyGroup});
            }
            div.add(new Component[]{fieldSetRv});
            this.visible = this.visible || fieldSetRv.isVisible();
        } else {
            Components.permanentlyHide((MarkupContainer)div, ID_FIELD_SETS);
        }
        List collections = _NullSafe.stream((Collection)this.bs3Col.getCollections()).filter(new Predicate<CollectionLayoutData>(){

            @Override
            public boolean test(CollectionLayoutData collectionLayoutData) {
                return collectionLayoutData.getMetadataError() == null;
            }
        }).collect(Collectors.toList());
        if (!collections.isEmpty()) {
            RepeatingViewWithDynamicallyVisibleContent collectionRv = new RepeatingViewWithDynamicallyVisibleContent(ID_COLLECTIONS);
            EntityModel entityModel = (EntityModel)this.getModel();
            CollectionLayoutData snapshot = entityModel.getCollectionLayoutData();
            for (CollectionLayoutData collection : collections) {
                String id = collectionRv.newChildId();
                entityModel.setCollectionLayoutData(collection);
                ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(ComponentType.ENTITY_COLLECTION, (IModel<?>)entityModel);
                Component collectionPanel = componentFactory.createComponent(id, (IModel<?>)entityModel);
                collectionRv.add(collectionPanel);
            }
            div.add(new Component[]{collectionRv});
            this.visible = this.visible || collectionRv.isVisible();
            entityModel.setCollectionLayoutData(snapshot);
        } else {
            Components.permanentlyHide((MarkupContainer)div, ID_COLLECTIONS);
        }
        Col panel = this;
        if (this.visible) {
            panel.add(new Component[]{div});
        } else {
            Components.permanentlyHide((MarkupContainer)panel, div.getId());
        }
    }

    private RepeatingViewWithDynamicallyVisibleContent buildRows(String owningId, List<BS3Row> rows) {
        RepeatingViewWithDynamicallyVisibleContent rowRv = new RepeatingViewWithDynamicallyVisibleContent(owningId);
        for (BS3Row bs3Row : rows) {
            String id = rowRv.newChildId();
            Row row = new Row(id, (EntityModel)this.getModel(), bs3Row);
            rowRv.add(new Component[]{row});
        }
        return rowRv;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }
}

