/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.layout.bs3.row;

import org.apache.isis.applib.layout.grid.bootstrap3.BS3ClearFix;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Col;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Row;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3RowContent;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.clearfix.ClearFix;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.col.Col;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.col.RepeatingViewWithDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.panels.HasDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;

public class Row
extends PanelAbstract<ManagedObject, EntityModel>
implements HasDynamicallyVisibleContent {
    private static final long serialVersionUID = 1L;
    private static final String ID_ROW_CONTENTS = "rowContents";
    private final BS3Row bs3Row;
    private boolean visible = false;

    public Row(String id, EntityModel entityModel, BS3Row bs3Row) {
        super(id, entityModel);
        this.bs3Row = bs3Row;
        this.buildGui();
    }

    private void buildGui() {
        RepeatingViewWithDynamicallyVisibleContent rv = new RepeatingViewWithDynamicallyVisibleContent(ID_ROW_CONTENTS);
        for (BS3RowContent bs3RowContent : this.bs3Row.getCols()) {
            PanelAbstract rowContent;
            String id = rv.newChildId();
            if (bs3RowContent instanceof BS3Col) {
                BS3Col bs3Col = (BS3Col)bs3RowContent;
                Col col = new Col(id, (EntityModel)this.getModel(), bs3Col);
                this.visible = this.visible || col.isVisible();
                rowContent = col;
            } else if (bs3RowContent instanceof BS3ClearFix) {
                BS3ClearFix bs3ClearFix = (BS3ClearFix)bs3RowContent;
                rowContent = new ClearFix(id, (EntityModel)this.getModel(), bs3ClearFix);
            } else {
                throw new IllegalStateException("Unrecognized implementation of BS3RowContent");
            }
            rv.add(new Component[]{rowContent});
        }
        Row panel = this;
        if (this.visible) {
            Wkt.cssAppend(panel, "row");
            Wkt.cssAppend(panel, this.bs3Row.getCssClass());
            panel.add(new Component[]{rv});
        } else {
            Components.permanentlyHide((MarkupContainer)panel, rv.getId());
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }
}

