/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.layout.bs3.tabs;

import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.AjaxBootstrapTabbedPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Tab;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3TabGroup;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.util.ComponentHintKey;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.col.RepeatingViewWithDynamicallyVisibleContent;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.tabs.TabPanel;
import org.apache.isis.viewer.wicket.ui.panels.HasDynamicallyVisibleContent;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TabGroupPanel
extends AjaxBootstrapTabbedPanel<ITab>
implements HasDynamicallyVisibleContent {
    private static final long serialVersionUID = 1L;
    public static final String SESSION_ATTR_SELECTED_TAB = "selectedTab";
    private final ComponentHintKey selectedTabHintKey;
    private final EntityModel entityModel;

    private static List<ITab> tabsFor(final EntityModel entityModel, BS3TabGroup bs3TabGroup) {
        ArrayList<ITab> tabs = new ArrayList<ITab>();
        List tablist = _NullSafe.stream((Collection)bs3TabGroup.getTabs()).filter(BS3Tab.Predicates.notEmpty()).collect(Collectors.toList());
        for (final BS3Tab bs3Tab : tablist) {
            final RepeatingViewWithDynamicallyVisibleContent repeatingViewWithDynamicallyVisibleContent = TabPanel.newRows(entityModel, bs3Tab);
            String tabName = bs3Tab.getName();
            tabs.add((ITab)new AbstractTab((IModel)Model.of((Serializable)((Object)tabName))){
                private static final long serialVersionUID = 1L;

                public Panel getPanel(String panelId) {
                    return new TabPanel(panelId, entityModel, bs3Tab, repeatingViewWithDynamicallyVisibleContent);
                }

                public boolean isVisible() {
                    return repeatingViewWithDynamicallyVisibleContent.isVisible();
                }
            });
        }
        return tabs;
    }

    public TabGroupPanel(String id, EntityModel entityModel, BS3TabGroup bs3TabGroup) {
        super(id, TabGroupPanel.tabsFor(entityModel, bs3TabGroup));
        this.entityModel = entityModel;
        this.selectedTabHintKey = ComponentHintKey.create((IsisAppCommonContext)entityModel.getCommonContext(), (Component)this, (String)SESSION_ATTR_SELECTED_TAB);
    }

    protected void onInitialize() {
        this.setSelectedTabFromSessionIfAny(this);
        super.onInitialize();
    }

    public TabbedPanel<ITab> setSelectedTab(int index) {
        this.selectedTabHintKey.set(this.entityModel.getOwnerBookmark(), "" + index);
        return super.setSelectedTab(index);
    }

    private void setSelectedTabFromSessionIfAny(AjaxBootstrapTabbedPanel<ITab> ajaxBootstrapTabbedPanel) {
        String selectedTabStr = this.selectedTabHintKey.get(this.entityModel.getOwnerBookmark());
        Integer tabIndex = this.parse(selectedTabStr);
        if (tabIndex != null) {
            int numTabs = ajaxBootstrapTabbedPanel.getTabs().size();
            if (tabIndex < numTabs) {
                ajaxBootstrapTabbedPanel.setSelectedTab(tabIndex.intValue());
            }
        }
    }

    private Integer parse(String selectedTabStr) {
        try {
            return Integer.parseInt(selectedTabStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public boolean isVisible() {
        return _NullSafe.stream((Collection)this.getTabs()).anyMatch(ITab::isVisible);
    }
}

