/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.property;

import org.apache.isis.commons.internal.base._Either;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.hints.IsisPropertyEditCompletedEvent;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ScalarPropertyModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.panels.PromptFormAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;

class PropertyEditForm
extends PromptFormAbstract<ScalarPropertyModel> {
    private static final long serialVersionUID = 1L;

    public PropertyEditForm(String id, Component parentPanel, WicketViewerSettings settings, ScalarPropertyModel propertyModel) {
        super(id, parentPanel, settings, propertyModel);
    }

    private ScalarPropertyModel getScalarModel() {
        return (ScalarPropertyModel)super.getModel();
    }

    @Override
    protected void addParameters() {
        ScalarPropertyModel scalarModel = this.getScalarModel();
        WebMarkupContainer container = new WebMarkupContainer("property");
        this.add(new Component[]{container});
        this.newParamPanel(container, (IModel<?>)scalarModel);
    }

    private ScalarPanelAbstract newParamPanel(WebMarkupContainer container, IModel<?> model) {
        Component component = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)container, ComponentType.SCALAR_NAME_AND_VALUE, model);
        if (!(component instanceof ScalarPanelAbstract)) {
            return null;
        }
        ScalarPanelAbstract paramPanel = (ScalarPanelAbstract)component;
        paramPanel.setOutputMarkupId(true);
        paramPanel.notifyOnChange(this);
        return paramPanel;
    }

    @Override
    protected Object newCompletedEvent(AjaxRequestTarget target, Form<?> form) {
        return new IsisPropertyEditCompletedEvent((ScalarModel)this.getScalarModel(), target, form);
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, ScalarPanelAbstract scalarPanel) {
    }

    @Override
    protected _Either<ActionModel, ScalarPropertyModel> getMemberModel() {
        return _Either.right((Object)this.getScalarModel());
    }
}

