/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.property;

import java.io.Serializable;
import org.apache.isis.core.metamodel.commons.ScalarRepresentation;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.common.model.object.ObjectUiModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ScalarPropertyModel;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;

public class PropertyEditPanel
extends PanelAbstract<ManagedObject, ScalarPropertyModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_HEADER = "header";
    private static final String ID_PROPERTY_NAME = "propertyName";
    private boolean showHeader = true;

    public PropertyEditPanel(String id, ScalarPropertyModel scalarModel) {
        super(id, scalarModel.copyHaving(ScalarRepresentation.EDITING, ObjectUiModel.RenderingHint.REGULAR));
        this.buildGui((ScalarModel)scalarModel);
    }

    protected void onConfigure() {
        super.onConfigure();
        this.buildGui((ScalarModel)this.getScalarModel());
    }

    private void buildGui(ScalarModel scalarModel) {
        this.buildGuiForParameters(scalarModel);
    }

    ScalarPropertyModel getScalarModel() {
        return (ScalarPropertyModel)super.getModel();
    }

    public PropertyEditPanel setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
        return this;
    }

    private void buildGuiForParameters(ScalarModel scalarModel) {
        WebMarkupContainer header = this.addHeader();
        this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, ComponentType.PROPERTY_EDIT_FORM, (IModel<?>)this.getScalarModel());
        this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)header, ComponentType.ENTITY_ICON_AND_TITLE, (IModel<?>)scalarModel.getParentUiModel());
        Wkt.labelAdd((MarkupContainer)header, ID_PROPERTY_NAME, (IModel<String>)((IModel & Serializable)() -> ((ScalarPropertyModel)this.getScalarModel()).getFriendlyName())).setEscapeModelStrings(true);
    }

    private WebMarkupContainer addHeader() {
        WebMarkupContainer header = new WebMarkupContainer(ID_HEADER){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(PropertyEditPanel.this.showHeader);
            }
        };
        this.addOrReplace(new Component[]{header});
        return header;
    }
}

