/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import org.apache.isis.commons.collections.Can;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public abstract class ComponentFactoryScalarAbstract
extends ComponentFactoryAbstract {
    private static final long serialVersionUID = 1L;
    private final Can<Class<?>> scalarTypes;

    protected ComponentFactoryScalarAbstract(Class<?> componentClass, Class<?> ... scalarTypes) {
        this(componentClass, Can.ofArray((Object[])scalarTypes));
    }

    protected ComponentFactoryScalarAbstract(Class<?> componentClass, Can<Class<?>> scalarTypes) {
        super(ComponentType.SCALAR_NAME_AND_VALUE, componentClass);
        this.scalarTypes = scalarTypes;
    }

    @Override
    public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
        if (!(model instanceof ScalarModel)) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        ScalarModel scalarModel = (ScalarModel)model;
        if (!scalarModel.isScalarTypeAnyOf(this.scalarTypes)) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        boolean hasChoices = scalarModel.hasChoices();
        return this.appliesIf(!hasChoices);
    }

    @Override
    public final Component createComponent(String id, IModel<?> model) {
        return this.createComponent(id, (ScalarModel)model);
    }

    protected abstract Component createComponent(String var1, ScalarModel var2);

    public Can<Class<?>> getScalarTypes() {
        return this.scalarTypes;
    }
}

