/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.services.metamodel.BeanSort;
import org.apache.isis.applib.services.metamodel.MetaModelService;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._Refs;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.debug._Probe;
import org.apache.isis.core.metamodel.commons.ScalarRepresentation;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.labelat.LabelAtFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.common.model.feature.ParameterUiModel;
import org.apache.isis.viewer.common.model.object.ObjectUiModel;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.InlinePromptContext;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ScalarPropertyModel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.LinkAndLabelFactory;
import org.apache.isis.viewer.wicket.ui.components.property.PropertyEditFormPanel;
import org.apache.isis.viewer.wicket.ui.components.property.PropertyEditPanel;
import org.apache.isis.viewer.wicket.ui.components.propertyheader.PropertyEditPromptHeaderPanel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarModelSubscriber;
import org.apache.isis.viewer.wicket.ui.components.widgets.linkandlabel.ActionLink;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public abstract class ScalarPanelAbstract
extends PanelAbstract<ManagedObject, ScalarModel>
implements ScalarModelSubscriber {
    private static final long serialVersionUID = 1L;
    protected static final String ID_SCALAR_TYPE_CONTAINER = "scalarTypeContainer";
    protected static final String ID_SCALAR_IF_COMPACT = "scalarIfCompact";
    protected static final String ID_SCALAR_IF_REGULAR = "scalarIfRegular";
    protected static final String ID_SCALAR_NAME = "scalarName";
    protected static final String ID_SCALAR_VALUE = "scalarValue";
    protected static final String ID_SCALAR_VALUE_INLINE_PROMPT_LINK = "scalarValueInlinePromptLink";
    protected static final String ID_SCALAR_VALUE_INLINE_PROMPT_LABEL = "scalarValueInlinePromptLabel";
    public static final String ID_SCALAR_IF_REGULAR_INLINE_PROMPT_FORM = "scalarIfRegularInlinePromptForm";
    private static final String ID_EDIT_PROPERTY = "editProperty";
    private static final String ID_FEEDBACK = "feedback";
    private static final String ID_ASSOCIATED_ACTION_LINKS_BELOW = "associatedActionLinksBelow";
    private static final String ID_ASSOCIATED_ACTION_LINKS_RIGHT = "associatedActionLinksRight";
    private final ScalarModel scalarModel;
    private Component scalarIfCompact;
    private MarkupContainer scalarIfRegular;
    private WebMarkupContainer scalarTypeContainer;
    private WebMarkupContainer scalarIfRegularInlinePromptForm;
    WebMarkupContainer inlinePromptLink;
    private final List<ScalarModelSubscriber> subscribers = _Lists.newArrayList();

    public Repaint updateIfNecessary(@NonNull ParameterUiModel paramModel, @NonNull Optional<AjaxRequestTarget> target) {
        boolean valueChanged;
        if (paramModel == null) {
            throw new NullPointerException("paramModel is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        Consent visibilityConsent = paramModel.getParameterNegotiationModel().getVisibilityConsent(paramModel.getParameterIndex());
        boolean visibilityBefore = this.isVisible();
        boolean visibilityAfter = visibilityConsent.isAllowed();
        this.setVisible(visibilityAfter);
        Consent usabilityConsent = paramModel.getParameterNegotiationModel().getUsabilityConsent(paramModel.getParameterIndex());
        boolean usabilityBefore = this.isEnabled();
        boolean usabilityAfter = usabilityConsent.isAllowed();
        if (usabilityAfter) {
            this.onEditable(target);
        } else {
            this.onNotEditable(usabilityConsent.getReason(), target);
        }
        ManagedObject paramValue = paramModel.getValue();
        boolean bl = valueChanged = !Objects.equals(this.scalarModel.getObject(), paramValue);
        if (valueChanged) {
            if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)paramValue)) {
                this.scalarModel.setObject(null);
            } else {
                this.scalarModel.setObject(paramValue);
            }
            this.scalarModel.clearPending();
        }
        if (!visibilityBefore || !visibilityAfter) {
            return Repaint.ENTIRE_FORM;
        }
        if (!usabilityAfter || !usabilityBefore) {
            return Repaint.PARAM_ONLY;
        }
        return valueChanged ? Repaint.PARAM_ONLY : Repaint.NOTHING;
    }

    protected ScalarPanelAbstract(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
        this.scalarModel = scalarModel;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGuiAndCallHooks();
        this.setOutputMarkupId(true);
    }

    private void buildGuiAndCallHooks() {
        this.buildGui();
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        String disableReasonIfAny = scalarModel.disableReasonIfAny();
        boolean mustBeEditable = scalarModel.mustBeEditable();
        if (disableReasonIfAny != null) {
            if (mustBeEditable) {
                this.onInitializeNotEditable();
            } else {
                this.onInitializeReadonly(disableReasonIfAny);
            }
        } else if (scalarModel.isViewMode()) {
            this.onInitializeNotEditable();
        } else {
            this.onInitializeEditable();
        }
    }

    public final String getCssClassName() {
        return _Strings.decapitalize((String)this.getClass().getSimpleName());
    }

    protected abstract InlinePromptConfig getInlinePromptConfig();

    private void buildGui() {
        this.scalarTypeContainer = Wkt.containerAdd((MarkupContainer)this, ID_SCALAR_TYPE_CONTAINER);
        Wkt.cssAppend(this.scalarTypeContainer, this.getCssClassName());
        this.scalarIfCompact = this.createComponentForCompact();
        this.scalarIfRegular = this.createComponentForRegular();
        this.scalarIfRegular.setOutputMarkupId(true);
        this.scalarTypeContainer.addOrReplace(new Component[]{this.scalarIfCompact, this.scalarIfRegular});
        ScalarModel.AssociatedActions associatedActions = this.scalarModel.getAssociatedActions();
        Optional inlineActionIfAny = associatedActions.getFirstAssociatedWithInlineAsIfEdit();
        List remainingAssociated = associatedActions.getRemainingAssociated();
        Can remainingLinkAndLabels = (Can)remainingAssociated.stream().map(LinkAndLabelFactory.forPropertyOrParameter(this.scalarModel)).collect(Can.toCan());
        InlinePromptConfig inlinePromptConfig = this.getInlinePromptConfig();
        if (inlinePromptConfig.isSupported()) {
            this.scalarIfRegularInlinePromptForm = this.createInlinePromptForm();
            this.scalarTypeContainer.addOrReplace(new Component[]{this.scalarIfRegularInlinePromptForm});
            this.inlinePromptLink = this.createInlinePromptLink();
            this.scalarIfRegular.add(new Component[]{this.inlinePromptLink});
            this.scalarModel.setInlinePromptContext(new InlinePromptContext(this.getComponentForRegular(), this.scalarIfRegularInlinePromptForm, (MarkupContainer)this.scalarTypeContainer));
            _Refs.ObjectReference componentToHideRef = _Refs.objectRef((Object)this.inlinePromptLink);
            if (this.scalarModel.getPromptStyle().isInline() && this.scalarModel.canEnterEditMode()) {
                Wkt.behaviorAddOnClick((MarkupContainer)this.inlinePromptLink, (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)this::onPropertyInlineEditClick));
                componentToHideRef.setValue((Object)inlinePromptConfig.getComponentToHideIfAny());
            } else {
                inlineActionIfAny.map(LinkAndLabelFactory.forPropertyOrParameter(this.scalarModel)).map(LinkAndLabel::getUiComponent).map(ActionLink.class::cast).filter(ActionLink::isVisible).filter(ActionLink::isEnabled).ifPresent(actionLinkInlineAsIfEdit -> {
                    Wkt.behaviorAddOnClick((MarkupContainer)this.inlinePromptLink, (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)actionLinkInlineAsIfEdit::onClick));
                    componentToHideRef.setValue((Object)inlinePromptConfig.getComponentToHideIfAny());
                });
            }
            componentToHideRef.getValue().ifPresent(componentToHide -> componentToHide.setVisibilityAllowed(false));
        }
        if (this.scalarModel.isProperty() && this.scalarModel.getMode() == ScalarRepresentation.VIEWING && (this.scalarModel.getPromptStyle().isDialog() || !this.scalarModel.canEnterEditMode())) {
            this.getScalarValueComponent().add(new Behavior[]{new AttributeAppender("tabindex", (Serializable)((Object)"-1"))});
        }
        this.addPositioningCssTo(this.scalarIfRegular, (Can<LinkAndLabel>)remainingLinkAndLabels);
        this.addActionLinksBelowAndRight(this.scalarIfRegular, (Can<LinkAndLabel>)remainingLinkAndLabels);
        this.addEditPropertyTo(this.scalarIfRegular);
        this.addFeedbackOnlyTo(this.scalarIfRegular, this.getScalarValueComponent());
        this.getRendering().buildGui(this);
        this.addCssFromMetaModel();
        this.notifyOnChange(this);
        this.addFormComponentBehaviourToUpdateSubscribers();
    }

    protected void onInitializeNotEditable() {
    }

    protected void onInitializeReadonly(String disableReason) {
    }

    protected void onInitializeEditable() {
    }

    protected void onNotEditable(String disableReason, Optional<AjaxRequestTarget> target) {
    }

    protected void onEditable(@NonNull Optional<AjaxRequestTarget> target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
    }

    private void addCssFromMetaModel() {
        String cssForMetaModel = ((ScalarModel)this.getModel()).getCssClass();
        Wkt.cssAppend(this, cssForMetaModel);
        ScalarModel model = (ScalarModel)this.getModel();
        CssClassFacet facet = (CssClassFacet)model.getFacet(CssClassFacet.class);
        if (facet != null) {
            ManagedObject parentAdapter = model.getParentUiModel().getManagedObject();
            String cssClass = facet.cssClass(parentAdapter);
            Wkt.cssAppend(this, cssClass);
        }
    }

    protected void onConfigure() {
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        boolean hidden = scalarModel.whetherHidden();
        this.setVisibilityAllowed(!hidden);
        super.onConfigure();
    }

    public void notifyOnChange(ScalarModelSubscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    private void addFormComponentBehaviourToUpdateSubscribers() {
        Component scalarValueComponent = this.getScalarValueComponent();
        if (scalarValueComponent == null) {
            return;
        }
        for (Behavior b : scalarValueComponent.getBehaviors(ScalarUpdatingBehavior.class)) {
            scalarValueComponent.remove(new Behavior[]{b});
        }
        scalarValueComponent.add(new Behavior[]{new ScalarUpdatingBehavior(this)});
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, ScalarPanelAbstract scalarPanel) {
        if (((ScalarModel)this.getModel()).isParameter()) {
            Wkt.javaScriptAdd(target, Wkt.EventTopic.FOCUS_FIRST_PARAMETER, this.getMarkupId());
        }
    }

    @Override
    public void onError(AjaxRequestTarget target, ScalarPanelAbstract scalarPanel) {
    }

    protected Rendering getRendering() {
        return Rendering.renderingFor(this.scalarModel.getRenderingHint());
    }

    protected final Component getComponentForRegular() {
        return this.scalarIfRegular;
    }

    protected abstract MarkupContainer createComponentForRegular();

    protected abstract Component createComponentForCompact();

    protected Label createScalarName(String id, String labelCaption) {
        String label;
        Label scalarName = Wkt.label(id, labelCaption);
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        if (scalarModel.isRequired() && scalarModel.isEnabled() && !_Strings.isNullOrEmpty((CharSequence)(label = scalarName.getDefaultModelObjectAsString()))) {
            Wkt.cssAppend(scalarName, "mandatory");
        }
        scalarName.setEscapeModelStrings(true);
        return scalarName;
    }

    private WebMarkupContainer createInlinePromptForm() {
        WebMarkupContainer scalarIfRegularInlinePromptForm = new WebMarkupContainer(ID_SCALAR_IF_REGULAR_INLINE_PROMPT_FORM);
        scalarIfRegularInlinePromptForm.setOutputMarkupId(true);
        scalarIfRegularInlinePromptForm.setVisible(false);
        return scalarIfRegularInlinePromptForm;
    }

    private WebMarkupContainer createInlinePromptLink() {
        IModel<String> inlinePromptModel = this.obtainInlinePromptModel();
        if (inlinePromptModel == null) {
            throw new IllegalStateException(this.getClass().getName() + ": obtainInlinePromptModel() returning null is not compatible with supportsInlinePrompt() returning true ");
        }
        WebMarkupContainer inlinePromptLink = new WebMarkupContainer(ID_SCALAR_VALUE_INLINE_PROMPT_LINK);
        inlinePromptLink.setOutputMarkupId(true);
        inlinePromptLink.setOutputMarkupPlaceholderTag(true);
        this.configureInlinePromptLink(inlinePromptLink);
        Component editInlineLinkLabel = this.createInlinePromptComponent(ID_SCALAR_VALUE_INLINE_PROMPT_LABEL, inlinePromptModel);
        inlinePromptLink.add(new Component[]{editInlineLinkLabel});
        return inlinePromptLink;
    }

    protected void configureInlinePromptLink(WebMarkupContainer inlinePromptLink) {
        Wkt.cssAppend(inlinePromptLink, this.obtainInlinePromptLinkCssIfAny());
    }

    protected String obtainInlinePromptLinkCssIfAny() {
        return "form-control form-control-sm";
    }

    protected Component createInlinePromptComponent(String id, IModel<String> inlinePromptModel) {
        return Wkt.labelNoTab(id, inlinePromptModel);
    }

    protected IModel<String> obtainInlinePromptModel() {
        return null;
    }

    private void onPropertyInlineEditClick(AjaxRequestTarget target) {
        this.scalarModel.toEditMode();
        this.switchFormForInlinePrompt(target);
        this.getComponentForRegular().setVisible(false);
        this.scalarIfRegularInlinePromptForm.setVisible(true);
        target.add(new Component[]{this.scalarTypeContainer});
        Wkt.focusOnMarkerAttribute((MarkupContainer)this.scalarIfRegularInlinePromptForm, target);
    }

    private void switchFormForInlinePrompt(AjaxRequestTarget target) {
        this.scalarIfRegularInlinePromptForm = (PropertyEditFormPanel)this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this.scalarTypeContainer, ID_SCALAR_IF_REGULAR_INLINE_PROMPT_FORM, ComponentType.PROPERTY_EDIT_FORM, (IModel<?>)this.scalarModel);
        this.onSwitchFormForInlinePrompt(this.scalarIfRegularInlinePromptForm, target);
    }

    protected void onSwitchFormForInlinePrompt(WebMarkupContainer inlinePromptForm, AjaxRequestTarget target) {
    }

    protected void addEditPropertyTo(MarkupContainer scalarIfRegularFormGroup) {
        if (this.scalarModel.canEnterEditMode() && (this.scalarModel.getPromptStyle().isDialog() || !this.getInlinePromptConfig().isSupported())) {
            WebMarkupContainer editProperty = Wkt.containerAdd(scalarIfRegularFormGroup, ID_EDIT_PROPERTY);
            Wkt.behaviorAddOnClick((MarkupContainer)editProperty, (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)this::onPropertyEditClick));
        } else {
            Components.permanentlyHide(scalarIfRegularFormGroup, ID_EDIT_PROPERTY);
        }
    }

    private void onPropertyEditClick(AjaxRequestTarget target) {
        ObjectSpecification specification = this.scalarModel.getScalarTypeSpec();
        MetaModelService metaModelService = (MetaModelService)this.getServiceRegistry().lookupServiceElseFail(MetaModelService.class);
        BeanSort sort = metaModelService.sortOf(specification.getCorrespondingClass(), MetaModelService.Mode.RELAXED);
        ActionPrompt prompt = ActionPromptProvider.getFrom((Component)this).getActionPrompt(this.scalarModel.getPromptStyle(), sort);
        PropertyEditPromptHeaderPanel titlePanel = new PropertyEditPromptHeaderPanel(prompt.getTitleId(), (ScalarPropertyModel)this.scalarModel);
        PropertyEditPanel propertyEditPanel = (PropertyEditPanel)this.getComponentFactoryRegistry().createComponent(ComponentType.PROPERTY_EDIT_PROMPT, prompt.getContentId(), (IModel<?>)this.scalarModel);
        propertyEditPanel.setShowHeader(false);
        prompt.setTitle((Component)titlePanel, target);
        prompt.setPanel((Component)propertyEditPanel, target);
        prompt.showPrompt(target);
    }

    protected abstract Component getScalarValueComponent();

    private void addFeedbackOnlyTo(MarkupContainer markupContainer, Component component) {
        markupContainer.addOrReplace(new Component[]{new NotificationPanel(ID_FEEDBACK, component, (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter(component))});
    }

    private void addActionLinksBelowAndRight(MarkupContainer labelIfRegular, Can<LinkAndLabel> linkAndLabels) {
        Can linksBelow = linkAndLabels.filter(LinkAndLabel.isPositionedAt((ActionLayout.Position)ActionLayout.Position.BELOW));
        AdditionalLinksPanel.addAdditionalLinks(labelIfRegular, ID_ASSOCIATED_ACTION_LINKS_BELOW, (Can<LinkAndLabel>)linksBelow, AdditionalLinksPanel.Style.INLINE_LIST);
        Can linksRight = linkAndLabels.filter(LinkAndLabel.isPositionedAt((ActionLayout.Position)ActionLayout.Position.RIGHT));
        AdditionalLinksPanel.addAdditionalLinks(labelIfRegular, ID_ASSOCIATED_ACTION_LINKS_RIGHT, (Can<LinkAndLabel>)linksRight, AdditionalLinksPanel.Style.DROPDOWN);
    }

    private void addPositioningCssTo(MarkupContainer markupContainer, Can<LinkAndLabel> actionLinks) {
        Wkt.cssAppend(markupContainer, ScalarPanelAbstract.determinePropParamLayoutCss((ScalarModel)this.getModel()));
        Wkt.cssAppend(markupContainer, ScalarPanelAbstract.determineActionLayoutPositioningCss(actionLinks));
    }

    private static String determinePropParamLayoutCss(ScalarModel model) {
        LabelAtFacet facet = (LabelAtFacet)model.getFacet(LabelAtFacet.class);
        if (facet != null) {
            switch (facet.label()) {
                case LEFT: {
                    return "label-left";
                }
                case RIGHT: {
                    return "label-right";
                }
                case NONE: {
                    return "label-none";
                }
                case TOP: {
                    return "label-top";
                }
            }
        }
        return "label-left";
    }

    private static String determineActionLayoutPositioningCss(Can<LinkAndLabel> entityActionLinks) {
        return entityActionLinks.stream().anyMatch(LinkAndLabel.isPositionedAt((ActionLayout.Position)ActionLayout.Position.RIGHT)) ? "actions-right" : null;
    }

    public void repaint(AjaxRequestTarget target) {
        target.add(new Component[]{this});
    }

    protected ScalarModel scalarModel() {
        return this.scalarModel;
    }

    public static enum Rendering {
        COMPACT{

            @Override
            public String getLabelCaption(LabeledWebMarkupContainer labeledContainer) {
                return "";
            }

            @Override
            public void buildGui(ScalarPanelAbstract panel) {
                panel.scalarIfCompact.setVisible(true);
                panel.scalarIfRegular.setVisible(false);
                Components.permanentlyHide(panel.scalarIfRegular, ScalarPanelAbstract.ID_SCALAR_NAME);
            }
        }
        ,
        REGULAR{

            @Override
            public String getLabelCaption(LabeledWebMarkupContainer labeledContainer) {
                return (String)labeledContainer.getLabel().getObject();
            }

            @Override
            public void buildGui(ScalarPanelAbstract panel) {
                panel.scalarIfRegular.setVisible(true);
                panel.scalarIfCompact.setVisible(false);
            }
        };


        public abstract String getLabelCaption(LabeledWebMarkupContainer var1);

        public abstract void buildGui(ScalarPanelAbstract var1);

        private static Rendering renderingFor(ObjectUiModel.RenderingHint renderingHint) {
            return renderingHint.isRegular() ? REGULAR : COMPACT;
        }
    }

    static class ScalarUpdatingBehavior
    extends AjaxFormComponentUpdatingBehavior {
        private static final long serialVersionUID = 1L;
        private final ScalarPanelAbstract scalarPanel;

        private ScalarUpdatingBehavior(ScalarPanelAbstract scalarPanel) {
            super("change");
            this.scalarPanel = scalarPanel;
        }

        protected void onUpdate(AjaxRequestTarget target) {
            _Probe.entryPoint((_Probe.EntryPoint)_Probe.EntryPoint.USER_INTERACTION, (String)"Wicket Ajax Request, originating from User either having changed a Property value during inline editing or having changed a Parameter value within an open ActionPrompt.");
            for (ScalarModelSubscriber subscriber : this.scalarPanel.subscribers) {
                subscriber.onUpdate(target, this.scalarPanel);
            }
        }

        protected void onError(AjaxRequestTarget target, RuntimeException e) {
            super.onError(target, e);
            for (ScalarModelSubscriber subscriber : this.scalarPanel.subscribers) {
                subscriber.onError(target, this.scalarPanel);
            }
        }
    }

    public static class InlinePromptConfig {
        private final boolean supported;
        private final Component componentToHideIfAny;

        public static InlinePromptConfig supported() {
            return new InlinePromptConfig(true, null);
        }

        public static InlinePromptConfig notSupported() {
            return new InlinePromptConfig(false, null);
        }

        public static InlinePromptConfig supportedAndHide(Component componentToHideIfAny) {
            return new InlinePromptConfig(true, componentToHideIfAny);
        }

        private InlinePromptConfig(boolean supported, Component componentToHideIfAny) {
            this.supported = supported;
            this.componentToHideIfAny = componentToHideIfAny;
        }

        boolean isSupported() {
            return this.supported;
        }

        Component getComponentToHideIfAny() {
            return this.componentToHideIfAny;
        }
    }

    public static enum Repaint {
        ENTIRE_FORM,
        PARAM_ONLY,
        NOTHING;

    }
}

