/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.apache.isis.applib.id.LogicalType;
import org.apache.isis.core.metamodel.objectmanager.memento.ObjectMemento;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.viewer.common.model.feature.ParameterUiModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.Select2;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ObjectAdapterMementoProviderAbstract;
import org.apache.isis.viewer.wicket.ui.util.Tooltips;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.wicketstuff.select2.ChoiceProvider;

public abstract class ScalarPanelSelectAbstract
extends ScalarPanelAbstract {
    private static final long serialVersionUID = 1L;
    protected Select2 select2;

    public ScalarPanelSelectAbstract(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    protected Select2 createSelect2(String id) {
        Select2 select2 = Select2.createSelect2(id, this.scalarModel());
        this.setProviderAndCurrAndPending(select2);
        select2.setRequired(this.scalarModel().isRequired());
        return select2;
    }

    protected FormGroup createFormGroupAndName(FormComponent<?> component, String formGroupId, String nameId) {
        FormGroup formGroup = new FormGroup(formGroupId, component);
        formGroup.add(new Component[]{component});
        String labelCaption = this.getRendering().getLabelCaption((LabeledWebMarkupContainer)this.select2.asComponent());
        Label scalarName = this.createScalarName(nameId, labelCaption);
        ((ScalarModel)this.getModel()).getDescribedAs().ifPresent(describedAs -> Tooltips.addTooltip((Component)scalarName, describedAs));
        formGroup.addOrReplace(new Component[]{scalarName});
        return formGroup;
    }

    protected FormGroup createFormGroup(FormComponent<?> formComponent) {
        this.setOutputMarkupId(true);
        this.select2.asComponent().setOutputMarkupId(true);
        String name = this.scalarModel().getFriendlyName();
        this.select2.setLabel((Model<String>)Model.of((Serializable)((Object)name)));
        FormGroup formGroup = this.createFormGroupAndName(formComponent, "scalarIfRegular", "scalarName");
        this.addStandardSemantics();
        ScalarModel model = (ScalarModel)this.getModel();
        if (model.isRequired() && model.isEnabled()) {
            Wkt.cssAppend(formGroup, "mandatory");
        }
        return formGroup;
    }

    protected void addStandardSemantics() {
        this.select2.setRequired(((ScalarModel)this.getModel()).isRequired());
        this.select2.add(new Select2Validator(this.scalarModel()));
    }

    @Override
    protected Component getScalarValueComponent() {
        return this.select2.asComponent();
    }

    private void setProviderAndCurrAndPending(Select2 select2) {
        boolean dependsOnPreviousArgs;
        ChoiceProvider<ObjectMemento> choiceProvider = this.buildChoiceProvider();
        select2.setProvider(choiceProvider);
        ((ScalarModel)this.getModel()).clearPending();
        boolean bl = dependsOnPreviousArgs = choiceProvider instanceof ObjectAdapterMementoProviderAbstract && ((ObjectAdapterMementoProviderAbstract)choiceProvider).dependsOnPreviousArgs();
        if (dependsOnPreviousArgs) {
            this.syncIfNull(select2);
        }
    }

    protected abstract ChoiceProvider<ObjectMemento> buildChoiceProvider();

    protected abstract void syncIfNull(Select2 var1);

    @Override
    protected void onSwitchFormForInlinePrompt(WebMarkupContainer inlinePromptForm, AjaxRequestTarget target) {
        Wkt.javaScriptAdd(target, Wkt.EventTopic.OPEN_SELECT2, inlinePromptForm.getMarkupId());
    }

    @Override
    protected void onNotEditable(String disableReason, Optional<AjaxRequestTarget> target) {
        this.setEnabled(false);
    }

    @Override
    protected void onEditable(Optional<AjaxRequestTarget> target) {
        this.setEnabled(true);
    }

    @Override
    public ScalarPanelAbstract.Repaint updateIfNecessary(@NonNull ParameterUiModel paramModel, @NonNull Optional<AjaxRequestTarget> target) {
        if (paramModel == null) {
            throw new NullPointerException("paramModel is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        ScalarPanelAbstract.Repaint repaint = super.updateIfNecessary(paramModel, target);
        boolean choicesUpdated = this.updateChoices();
        if (repaint == ScalarPanelAbstract.Repaint.NOTHING) {
            if (choicesUpdated) {
                return ScalarPanelAbstract.Repaint.PARAM_ONLY;
            }
            return ScalarPanelAbstract.Repaint.NOTHING;
        }
        return repaint;
    }

    private boolean updateChoices() {
        if (this.select2 == null) {
            return false;
        }
        this.setProviderAndCurrAndPending(this.select2);
        return true;
    }

    @Override
    public void repaint(AjaxRequestTarget target) {
        target.add(new Component[]{this});
    }

    static class Select2Validator
    implements IValidator<Object> {
        private static final long serialVersionUID = 1L;
        private final ScalarModel scalarModel;

        public Select2Validator(ScalarModel scalarModel) {
            this.scalarModel = scalarModel;
        }

        public void validate(IValidatable<Object> validatable) {
            ObjectMemento proposedValue;
            Object proposedValueObj = validatable.getValue();
            if (proposedValueObj instanceof List) {
                List proposedValueObjAsList = (List)proposedValueObj;
                if (proposedValueObjAsList.isEmpty()) {
                    return;
                }
                ObjectMemento memento = (ObjectMemento)proposedValueObjAsList.get(0);
                LogicalType logicalType = memento.getLogicalType();
                proposedValue = ObjectMemento.pack((Collection)proposedValueObjAsList, (LogicalType)logicalType);
            } else {
                proposedValue = (ObjectMemento)proposedValueObj;
            }
            ManagedObject proposedAdapter = this.scalarModel.getCommonContext().reconstructObject(proposedValue);
            String reasonIfAny = this.scalarModel.validate(proposedAdapter);
            if (reasonIfAny != null) {
                ValidationError error = new ValidationError();
                error.setMessage(reasonIfAny);
                validatable.error((IValidationError)error);
            }
        }
    }
}

