/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import java.io.Serializable;
import java.util.Locale;
import java.util.Optional;
import lombok.NonNull;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.core.metamodel.commons.ScalarRepresentation;
import org.apache.isis.core.metamodel.facets.SingleIntValueFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.typicallen.TypicalLengthFacet;
import org.apache.isis.core.metamodel.objectmanager.ObjectManager;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.util.CommonContextUtils;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.TextFieldValueModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.util.Tooltips;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.apache.wicket.validation.validator.StringValidator;

public abstract class ScalarPanelTextFieldAbstract<T extends Serializable>
extends ScalarPanelAbstract
implements TextFieldValueModel.ScalarModelProvider {
    private static final long serialVersionUID = 1L;
    protected final Class<T> cls;
    private AbstractTextComponent<T> textField;

    protected ScalarPanelTextFieldAbstract(String id, ScalarModel scalarModel, Class<T> cls) {
        super(id, scalarModel);
        this.cls = cls;
    }

    protected final IConverter<T> getConverter(ScalarModel scalarModel) {
        return this.getConverter(scalarModel.getMetaModel(), scalarModel.isEditMode() ? ScalarRepresentation.EDITING : ScalarRepresentation.VIEWING);
    }

    protected abstract IConverter<T> getConverter(@NonNull ObjectFeature var1, @NonNull ScalarRepresentation var2);

    protected AbstractTextComponent<T> createTextField(String id) {
        return Wkt.textFieldWithConverter(id, this.newTextFieldValueModel(), this.cls, this.getConverter((ScalarModel)this.getModel()));
    }

    protected final TextFieldValueModel<T> newTextFieldValueModel() {
        return new TextFieldValueModel(this);
    }

    @Override
    protected MarkupContainer createComponentForRegular() {
        this.textField = this.createTextField("scalarValue");
        this.textField.setOutputMarkupId(true);
        this.addStandardSemantics();
        MarkupContainer scalarIfRegularFormGroup = this.createScalarIfRegularFormGroup();
        return scalarIfRegularFormGroup;
    }

    @Override
    protected Component getScalarValueComponent() {
        return this.textField;
    }

    protected MarkupContainer createScalarIfRegularFormGroup() {
        Fragment textFieldFragment = this.createTextFieldFragment("scalarValueContainer");
        String name = ((ScalarModel)this.getModel()).getFriendlyName();
        this.textField.setLabel((IModel)Model.of((Serializable)((Object)name)));
        FormGroup formGroup = new FormGroup("scalarIfRegular", (FormComponent<?>)this.textField);
        textFieldFragment.add(new Component[]{this.textField});
        formGroup.add(new Component[]{textFieldFragment});
        String labelCaption = this.getRendering().getLabelCaption((LabeledWebMarkupContainer)this.textField);
        Label scalarName = this.createScalarName("scalarName", labelCaption);
        ((ScalarModel)this.getModel()).getDescribedAs().ifPresent(describedAs -> Tooltips.addTooltip((Component)scalarName, describedAs));
        formGroup.add(new Component[]{scalarName});
        return formGroup;
    }

    private Fragment createTextFieldFragment(String id) {
        return new Fragment(id, this.createTextFieldFragmentId(), (MarkupContainer)this);
    }

    protected String createTextFieldFragmentId() {
        return "text";
    }

    @Override
    protected Component createInlinePromptComponent(String id, IModel<String> inlinePromptModel) {
        Fragment fragment = Wkt.fragmentAddNoTab((MarkupContainer)this, id, "textInlinePrompt");
        Wkt.labelAdd((MarkupContainer)fragment, "scalarValue", inlinePromptModel);
        return fragment;
    }

    protected void addStandardSemantics() {
        this.textField.setRequired(((ScalarModel)this.getModel()).isRequired());
        this.setTextFieldSizeAndMaxLengthIfSpecified();
        this.addValidatorForIsisValidation();
    }

    private void setTextFieldSizeAndMaxLengthIfSpecified() {
        Integer maxLength = ScalarPanelTextFieldAbstract.getMaxLengthOf((ScalarModel)this.getModel());
        Integer typicalLength = ScalarPanelTextFieldAbstract.getTypicalLenghtOf((ScalarModel)this.getModel());
        if (typicalLength != null && maxLength != null && typicalLength > maxLength) {
            typicalLength = maxLength;
        }
        if (typicalLength != null) {
            this.textField.add(new Behavior[]{new AttributeModifier("size", (IModel)Model.of((Serializable)((Object)("" + typicalLength))))});
        }
        if (maxLength != null) {
            this.textField.add(new Behavior[]{new AttributeModifier("maxlength", (IModel)Model.of((Serializable)((Object)("" + maxLength))))});
            if (this.cls.equals(String.class)) {
                this.textField.add(new Behavior[]{StringValidator.maximumLength((int)maxLength)});
            }
        }
    }

    private void addValidatorForIsisValidation() {
        final ScalarModel scalarModel = (ScalarModel)this.getModel();
        this.textField.add(new IValidator<T>(){
            private static final long serialVersionUID = 1L;
            private transient IsisAppCommonContext commonContext;

            public void validate(IValidatable<T> validatable) {
                Serializable proposedValue = (Serializable)validatable.getValue();
                ManagedObject proposedAdapter = this.objectManager().adapt((Object)proposedValue);
                String reasonIfAny = scalarModel.validate(proposedAdapter);
                if (reasonIfAny != null) {
                    ValidationError error = new ValidationError();
                    error.setMessage(reasonIfAny);
                    validatable.error((IValidationError)error);
                }
            }

            private ObjectManager objectManager() {
                return this.getCommonContext().getObjectManager();
            }

            private IsisAppCommonContext getCommonContext() {
                this.commonContext = CommonContextUtils.computeIfAbsent((IsisAppCommonContext)this.commonContext);
                return this.commonContext;
            }
        });
    }

    @Override
    protected Component createComponentForCompact() {
        return Wkt.labelAdd((MarkupContainer)this.getCompactFragment(CompactType.SPAN), "scalarIfCompact", (IModel<String>)(IModel & Serializable)() -> {
            String asText = ((ScalarModel)this.getModel()).getObjectAsString();
            return asText;
        });
    }

    Fragment getCompactFragment(CompactType type) {
        Fragment compactFragment;
        switch (type) {
            case INPUT_CHECKBOX: {
                compactFragment = new Fragment("scalarIfCompact", "compactAsInputCheckbox", (MarkupContainer)this);
                break;
            }
            default: {
                compactFragment = new Fragment("scalarIfCompact", "compactAsSpan", (MarkupContainer)this);
            }
        }
        return compactFragment;
    }

    @Override
    protected ScalarPanelAbstract.InlinePromptConfig getInlinePromptConfig() {
        return ScalarPanelAbstract.InlinePromptConfig.supportedAndHide(this.textField);
    }

    @Override
    protected IModel<String> obtainInlinePromptModel() {
        IModel model = this.textField.getModel();
        return (IModel)_Casts.uncheckedCast((Object)model);
    }

    protected ToStringConvertingModel<T> toStringConvertingModelOf(IConverter<T> converter) {
        return new ToStringConvertingModel<T>(converter);
    }

    @Override
    protected void onInitializeNotEditable() {
        super.onInitializeNotEditable();
        this.textField.setEnabled(false);
        if (this.getWicketViewerSettings().isReplaceDisabledTagWithReadonlyTag()) {
            Wkt.behaviorAddReplaceDisabledTagWithReadonlyTag(this.textField);
        }
        this.clearTooltip();
    }

    @Override
    protected void onInitializeReadonly(String disableReason) {
        super.onInitializeReadonly(disableReason);
        this.textField.setEnabled(false);
        if (this.getWicketViewerSettings().isReplaceDisabledTagWithReadonlyTag()) {
            Wkt.behaviorAddReplaceDisabledTagWithReadonlyTag(this.textField);
        }
        this.inlinePromptLink.setEnabled(false);
        this.setTooltip(disableReason);
    }

    @Override
    protected void onInitializeEditable() {
        super.onInitializeEditable();
        this.textField.setEnabled(true);
        this.inlinePromptLink.setEnabled(true);
        this.clearTooltip();
    }

    @Override
    protected void onNotEditable(String disableReason, Optional<AjaxRequestTarget> target) {
        this.textField.setEnabled(false);
        this.inlinePromptLink.setEnabled(false);
        this.setTooltip(disableReason);
        target.ifPresent(ajax -> {
            ajax.add(new Component[]{this.textField});
            ajax.add(new Component[]{this.inlinePromptLink});
        });
    }

    @Override
    protected void onEditable(Optional<AjaxRequestTarget> target) {
        this.textField.setEnabled(true);
        this.inlinePromptLink.setEnabled(true);
        this.clearTooltip();
        target.ifPresent(ajax -> {
            ajax.add(new Component[]{this.textField});
            ajax.add(new Component[]{this.inlinePromptLink});
        });
    }

    private void setTooltip(String tooltip) {
        Tooltips.addTooltip(this.textField, tooltip);
        Tooltips.addTooltip((Component)this.inlinePromptLink, tooltip);
    }

    private void clearTooltip() {
        Tooltips.clearTooltip(this.textField);
        Tooltips.clearTooltip((Component)this.inlinePromptLink);
    }

    private static Integer getMaxLengthOf(@NonNull ScalarModel model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        return model.getScalarTypeSpec().lookupFacet(MaxLengthFacet.class).map(SingleIntValueFacet::value).orElse(null);
    }

    private static Integer getTypicalLenghtOf(@NonNull ScalarModel model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        return model.getScalarTypeSpec().lookupFacet(TypicalLengthFacet.class).map(SingleIntValueFacet::value).orElse(null);
    }

    protected AbstractTextComponent<T> getTextField() {
        return this.textField;
    }

    protected class ToStringConvertingModel<X>
    extends Model<String> {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final IConverter<X> converter;

        private ToStringConvertingModel(IConverter<X> converter) {
            if (converter == null) {
                throw new NullPointerException("converter is marked non-null but is null");
            }
            this.converter = converter;
        }

        public String getObject() {
            ManagedObject adapter = ScalarPanelTextFieldAbstract.this.scalarModel().getObject();
            Object value = ManagedObjects.UnwrapUtil.single((ManagedObject)adapter);
            String str = value != null ? this.converter.convertToString(_Casts.uncheckedCast((Object)value), ScalarPanelTextFieldAbstract.this.getLanguageProvider().getPreferredLanguage().orElseGet(Locale::getDefault)) : null;
            return str;
        }
    }

    public static enum CompactType {
        INPUT_CHECKBOX,
        SPAN;

    }
}

