/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import java.io.Serializable;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.wicket.model.Model;

public class TextFieldValueModel<T extends Serializable>
extends Model<T> {
    private static final long serialVersionUID = 1L;
    private final ScalarModelProvider scalarModelProvider;

    public TextFieldValueModel(ScalarModelProvider scalarModelProvider) {
        this.scalarModelProvider = scalarModelProvider;
    }

    public T getObject() {
        ScalarModel model = this.scalarModelProvider.getModel();
        ManagedObject objectAdapter = model.getObject();
        return this.unwrap(objectAdapter);
    }

    public void setObject(T object) {
        ScalarModel scalarModel = this.scalarModelProvider.getModel();
        if (object == null) {
            scalarModel.setObject(null);
        } else {
            ManagedObject objectAdapter = scalarModel.getCommonContext().getObjectManager().adapt(object);
            scalarModel.setObject(objectAdapter);
        }
    }

    private T unwrap(ManagedObject objectAdapter) {
        return (T)((Serializable)ManagedObjects.UnwrapUtil.single((ManagedObject)objectAdapter));
    }

    public static interface ScalarModelProvider {
        public ScalarModel getModel();
    }
}

