/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.blobclob;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.fileinput.BootstrapFileInputField;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.NamedWithMimeType;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.blobclob.ResourceLinkVolatile;
import org.apache.isis.viewer.wicket.ui.components.scalars.image.WicketImageUtil;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LambdaModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.IResource;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.danekja.java.util.function.serializable.SerializableSupplier;

public abstract class IsisBlobOrClobPanelAbstract<T extends NamedWithMimeType>
extends ScalarPanelAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_SCALAR_IF_REGULAR = "scalarIfRegular";
    private static final String ID_SCALAR_IF_REGULAR_DOWNLOAD = "scalarIfRegularDownload";
    private static final String ID_FILE_NAME = "fileName";
    private static final String ID_SCALAR_IF_REGULAR_CLEAR = "scalarIfRegularClear";
    private static final String ID_SCALAR_NAME = "scalarName";
    private static final String ID_SCALAR_VALUE = "scalarValue";
    private static final String ID_IMAGE = "scalarImage";
    private static final String ID_SCALAR_IF_COMPACT = "scalarIfCompact";
    private static final String ID_SCALAR_IF_COMPACT_DOWNLOAD = "scalarIfCompactDownload";
    private Image wicketImage;
    private FileUploadField fileUploadField;
    private Label fileNameLabel;

    protected FormGroup createComponentForRegular() {
        IModel friendlyNameModel = LambdaModel.of((SerializableSupplier & Serializable)() -> ((ScalarModel)this.getModel()).getFriendlyName());
        this.fileUploadField = this.createFileUploadField(ID_SCALAR_VALUE);
        this.fileUploadField.setLabel(friendlyNameModel);
        FormGroup scalarIfRegularFormGroup = new FormGroup(ID_SCALAR_IF_REGULAR, (FormComponent<?>)this.fileUploadField);
        scalarIfRegularFormGroup.add(new Component[]{this.fileUploadField});
        Wkt.labelAdd((MarkupContainer)scalarIfRegularFormGroup, ID_SCALAR_NAME, (IModel<String>)friendlyNameModel);
        this.wicketImage = this.asWicketImage(ID_IMAGE);
        if (this.wicketImage != null) {
            scalarIfRegularFormGroup.addOrReplace(new Component[]{this.wicketImage});
        } else {
            Components.permanentlyHide((MarkupContainer)scalarIfRegularFormGroup, ID_IMAGE);
        }
        this.updateFileNameLabel(ID_FILE_NAME, (MarkupContainer)scalarIfRegularFormGroup);
        this.updateDownloadLink(ID_SCALAR_IF_REGULAR_DOWNLOAD, (MarkupContainer)scalarIfRegularFormGroup);
        return scalarIfRegularFormGroup;
    }

    @Override
    protected Component getScalarValueComponent() {
        return this.fileUploadField;
    }

    @Override
    protected ScalarPanelAbstract.InlinePromptConfig getInlinePromptConfig() {
        return ScalarPanelAbstract.InlinePromptConfig.notSupported();
    }

    @Override
    protected Component createComponentForCompact() {
        WebMarkupContainer scalarIfCompact = new WebMarkupContainer(ID_SCALAR_IF_COMPACT);
        this.updateDownloadLink(ID_SCALAR_IF_COMPACT_DOWNLOAD, (MarkupContainer)scalarIfCompact);
        return scalarIfCompact;
    }

    private Image asWicketImage(String id) {
        ManagedObject adapter = ((ScalarModel)this.getModel()).getObject();
        if (adapter == null) {
            return null;
        }
        Object object = adapter.getPojo();
        if (!(object instanceof Blob)) {
            return null;
        }
        Blob blob = (Blob)object;
        return WicketImageUtil.asWicketImage(id, blob).orElse(null);
    }

    @Override
    protected void onInitializeNotEditable() {
        this.updateRegularFormComponents(InputFieldVisibility.VISIBLE, InputFieldEditability.NOT_EDITABLE, null, Optional.empty());
    }

    @Override
    protected void onInitializeReadonly(String disableReason) {
        this.updateRegularFormComponents(InputFieldVisibility.VISIBLE, InputFieldEditability.NOT_EDITABLE, null, Optional.empty());
    }

    @Override
    protected void onInitializeEditable() {
        this.updateRegularFormComponents(InputFieldVisibility.VISIBLE, InputFieldEditability.EDITABLE, null, Optional.empty());
    }

    private FileUploadField createFileUploadField(String componentId) {
        BootstrapFileInputField fileUploadField = new BootstrapFileInputField(componentId, (IModel)new IModel<List<FileUpload>>(){
            private static final long serialVersionUID = 1L;

            public void setObject(List<FileUpload> fileUploads) {
                if (fileUploads == null || fileUploads.isEmpty()) {
                    return;
                }
                Object blob = IsisBlobOrClobPanelAbstract.this.getBlobOrClobFrom(fileUploads);
                ManagedObject objectAdapter = IsisBlobOrClobPanelAbstract.this.scalarModel().getCommonContext().getObjectManager().adapt(blob);
                ((ScalarModel)IsisBlobOrClobPanelAbstract.this.getModel()).setObject(objectAdapter);
            }

            public void detach() {
            }

            public List<FileUpload> getObject() {
                return null;
            }
        });
        fileUploadField.getConfig().showUpload(false).mainClass("input-group-sm");
        return fileUploadField;
    }

    @Override
    protected void onNotEditable(String disableReason, Optional<AjaxRequestTarget> target) {
        this.updateRegularFormComponents(InputFieldVisibility.VISIBLE, InputFieldEditability.NOT_EDITABLE, disableReason, target);
    }

    @Override
    protected void onEditable(Optional<AjaxRequestTarget> target) {
        this.updateRegularFormComponents(InputFieldVisibility.VISIBLE, InputFieldEditability.EDITABLE, null, target);
    }

    protected abstract T getBlobOrClobFrom(List<FileUpload> var1);

    private Optional<T> getBlobOrClob(ScalarModel model) {
        ManagedObject adapter = model.getObject();
        Object pojo = ManagedObjects.UnwrapUtil.single((ManagedObject)adapter);
        return Optional.ofNullable((NamedWithMimeType)pojo);
    }

    public IsisBlobOrClobPanelAbstract(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    private void updateRegularFormComponents(InputFieldVisibility visibility, InputFieldEditability editability, String disabledReason, Optional<AjaxRequestTarget> target) {
        MarkupContainer formComponent = (MarkupContainer)this.getComponentForRegular();
        this.sync((Component)formComponent, visibility, editability, disabledReason, target);
        Component component = formComponent.get(ID_SCALAR_VALUE);
        InputFieldVisibility editingWidgetVisibility = editability == InputFieldEditability.EDITABLE ? InputFieldVisibility.VISIBLE : InputFieldVisibility.NOT_VISIBLE;
        this.sync(component, editingWidgetVisibility, null, disabledReason, target);
        this.addAcceptFilterTo(component);
        this.fileNameLabel = this.updateFileNameLabel(ID_FILE_NAME, formComponent);
        this.updateClearLink(editingWidgetVisibility, null, target);
        MarkupContainer downloadLink = this.updateDownloadLink(ID_SCALAR_IF_REGULAR_DOWNLOAD, formComponent);
        this.sync((Component)downloadLink, visibility, editability, disabledReason, target);
        this.sync((Component)this.wicketImage, visibility, editability, disabledReason, target);
    }

    private void sync(Component component, InputFieldVisibility visibility, InputFieldEditability editability, String disabledReason, Optional<AjaxRequestTarget> target) {
        if (component == null) {
            return;
        }
        component.setOutputMarkupId(true);
        if (visibility != null) {
            component.setVisible(visibility == InputFieldVisibility.VISIBLE);
            target.ifPresent(ajax -> Components.addToAjaxRequest(ajax, component));
        }
        if (editability != null) {
            // empty if block
        }
    }

    private String getAcceptFilter() {
        return this.scalarModel().getFileAccept();
    }

    private void addAcceptFilterTo(Component component) {
        final String filter = this.getAcceptFilter();
        if (component == null || filter == null || filter.isEmpty()) {
            return;
        }
        class AcceptAttributeModel
        extends Model<String> {
            private static final long serialVersionUID = 1L;

            AcceptAttributeModel() {
            }

            public String getObject() {
                return filter;
            }
        }
        component.add(new Behavior[]{new AttributeModifier("accept", (IModel)new AcceptAttributeModel())});
    }

    private Label updateFileNameLabel(String idFileName, MarkupContainer formComponent) {
        Label fileNameLabel = Wkt.labelAdd(formComponent, idFileName, (IModel<String>)(IModel & Serializable)() -> this.getBlobOrClobFromModel().map(NamedWithMimeType::getName).orElse(""));
        fileNameLabel.setOutputMarkupId(true);
        return fileNameLabel;
    }

    private void updateClearLink(InputFieldVisibility visibility, InputFieldEditability editability, Optional<AjaxRequestTarget> target) {
        MarkupContainer formComponent = (MarkupContainer)this.getComponentForRegular();
        formComponent.setOutputMarkupId(true);
        AjaxLink<Void> ajaxLink = Wkt.linkAdd(formComponent, ID_SCALAR_IF_REGULAR_CLEAR, (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)ajaxTarget -> {
            this.setEnabled(false);
            ScalarModel model = (ScalarModel)this.getModel();
            model.setObject(null);
            ajaxTarget.add(new Component[]{formComponent});
            ajaxTarget.add(new Component[]{this.fileNameLabel});
        });
        ajaxLink.setOutputMarkupId(true);
        Optional<T> blobOrClob = this.getBlobOrClobFromModel();
        Component clearButton = formComponent.get(ID_SCALAR_IF_REGULAR_CLEAR);
        clearButton.setVisible(blobOrClob.isPresent() && visibility == InputFieldVisibility.VISIBLE);
        clearButton.setEnabled(blobOrClob.isPresent());
        target.ifPresent(ajax -> {
            ajax.add(new Component[]{formComponent});
            ajax.add(new Component[]{clearButton});
            ajax.add(new Component[]{ajaxLink});
        });
    }

    private MarkupContainer updateDownloadLink(String downloadId, MarkupContainer container) {
        ResourceLinkVolatile resourceLink = this.createResourceLink(downloadId);
        if (resourceLink != null) {
            container.addOrReplace(new Component[]{resourceLink});
        } else {
            Components.permanentlyHide(container, downloadId);
        }
        return resourceLink;
    }

    private ResourceLinkVolatile createResourceLink(String id) {
        return this.getBlobOrClobFromModel().map(this::newResource).map(resource -> new ResourceLinkVolatile(id, (IResource)resource)).orElse(null);
    }

    private Optional<T> getBlobOrClobFromModel() {
        return this.getBlobOrClob((ScalarModel)this.getModel());
    }

    protected abstract IResource newResource(T var1);

    protected static enum InputFieldEditability {
        EDITABLE,
        NOT_EDITABLE;

    }

    protected static enum InputFieldVisibility {
        VISIBLE,
        NOT_VISIBLE;

    }
}

