/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.blobclob;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.blobclob.IsisBlobOrClobPanelAbstract;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.request.resource.CharSequenceResource;
import org.apache.wicket.request.resource.IResource;

public class IsisClobPanel
extends IsisBlobOrClobPanelAbstract<Clob> {
    private static final long serialVersionUID = 1L;
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    public IsisClobPanel(String id, ScalarModel model) {
        super(id, model);
    }

    @Override
    protected Clob getBlobOrClobFrom(List<FileUpload> fileUploads) {
        FileUpload fileUpload = fileUploads.get(0);
        String contentType = fileUpload.getContentType();
        String clientFileName = fileUpload.getClientFileName();
        String str = new String(fileUpload.getBytes(), CHARSET);
        Clob blob = new Clob(clientFileName, contentType, (CharSequence)str);
        return blob;
    }

    @Override
    protected IResource newResource(Clob clob) {
        return new CharSequenceResource(clob.getMimeType().getBaseType(), clob.getChars(), clob.getName());
    }
}

