/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.datepicker;

import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import java.util.Locale;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.wicket.model.converter.ConverterBasedOnValueSemantics;
import org.apache.isis.viewer.wicket.ui.components.scalars.datepicker.DateTimeConfig;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.convert.IConverter;

public class TextFieldWithDateTimePicker<T>
extends TextField<T>
implements IConverter<T> {
    private static final long serialVersionUID = 1L;
    protected final IConverter<T> converter;
    private final DateTimeConfig config;

    public TextFieldWithDateTimePicker(IsisAppCommonContext commonContext, String id, IModel<T> model, Class<T> type, IConverter<T> converter) {
        super(id, model, type);
        DateTimeConfig config = new DateTimeConfig();
        this.setOutputMarkupId(true);
        this.converter = converter;
        String dateTimePattern = ((ConverterBasedOnValueSemantics)this.converter).getEditingPattern();
        String pattern = this.convertToMomentJsFormat(dateTimePattern);
        config.withFormat(pattern);
        config.calendarWeeks(true);
        config.useCurrent(false);
        String datePickerMinDate = commonContext.getConfiguration().getViewer().getWicket().getDatePicker().getMinDate();
        String datePickerMaxDate = commonContext.getConfiguration().getViewer().getWicket().getDatePicker().getMaxDate();
        config.minDate(datePickerMinDate);
        config.maxDate(datePickerMaxDate);
        config.readonly(!this.isEnabled());
        this.config = config;
        this.add(new Behavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }});
    }

    private String convertToMomentJsFormat(String javaDateTimeFormat) {
        String momentJsFormat = javaDateTimeFormat;
        momentJsFormat = momentJsFormat.replace('d', 'D');
        momentJsFormat = momentJsFormat.replace('y', 'Y');
        return momentJsFormat;
    }

    public T convertToObject(String value, Locale locale) {
        return (T)this.converter.convertToObject(value, locale);
    }

    public String convertToString(T value, Locale locale) {
        return this.converter.convertToString(value, locale);
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (super.getType().isAssignableFrom(type)) {
            return this;
        }
        return super.getConverter(type);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (!this.isEnabled()) {
            return;
        }
        this.checkComponentTag(tag, "input");
        Attributes.set((ComponentTag)tag, (String)"type", (String)"text");
        Attributes.addClass((ComponentTag)tag, (String[])new String[]{"datetimepicker-input"});
        Attributes.set((ComponentTag)tag, (String)"data-toggle", (String)"datetimepicker");
        Attributes.set((ComponentTag)tag, (String)"data-target", (String)this.getMarkupId());
        Attributes.set((ComponentTag)tag, (String)"autocomplete", (String)"off");
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (!this.isEnabled()) {
            return;
        }
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(TextFieldWithDateTimePicker.class, "css/fa-patch.css")));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(TextFieldWithDateTimePicker.class, "css/tempusdominus-bootstrap-4.css")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(TextFieldWithDateTimePicker.class, "js/moment-with-locales.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(TextFieldWithDateTimePicker.class, "js/tempusdominus-bootstrap-4.js")));
        this.config.readonly(!this.isEnabled());
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createScript(this.config)));
    }

    private CharSequence createScript(DateTimeConfig config) {
        return JQuery.$((Component)this).chain((CharSequence)"datetimepicker", (Config)config, new Config[0]).get();
    }
}

