/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.markup;

import java.util.Optional;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;
import org.apache.isis.viewer.common.model.feature.ParameterUiModel;
import org.apache.isis.viewer.wicket.model.models.ScalarPropertyModel;
import org.apache.isis.viewer.wicket.model.models.ValueModel;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.model.IModel;

public class MarkupComponent
extends WebComponent {
    private static final long serialVersionUID = 1L;

    public MarkupComponent(String id, IModel<?> model) {
        super(id, model);
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        CharSequence htmlContent = this.extractHtmlOrElse(this.getDefaultModelObject(), "");
        this.replaceComponentTagBody(markupStream, openTag, htmlContent);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.setType(XmlTag.TagType.OPEN);
    }

    protected CharSequence extractHtmlOrElse(Object modelObject, String fallback) {
        if (modelObject == null) {
            return fallback;
        }
        if (modelObject instanceof ManagedObject) {
            ManagedObject adapter = (ManagedObject)modelObject;
            if (adapter.getPojo() == null) {
                return fallback;
            }
            String asHtml = this.lookupObjectFeatureIn(this.getDefaultModel()).map(feature -> adapter.titleString(conf -> conf.feature(feature))).orElseGet(() -> ((ManagedObject)adapter).titleString());
            if (asHtml != null) {
                return asHtml;
            }
            return fallback;
        }
        return modelObject.toString();
    }

    protected Optional<ObjectFeature> lookupObjectFeatureIn(IModel<?> model) {
        if (model instanceof ScalarPropertyModel) {
            return Optional.of(((ScalarPropertyModel)model).getMetaModel());
        }
        if (model instanceof ParameterUiModel) {
            return Optional.of(((ParameterUiModel)model).getMetaModel());
        }
        if (model instanceof ValueModel) {
            return Optional.ofNullable(((ValueModel)model).getActionModelHint()).map(act -> act.getAction());
        }
        return Optional.empty();
    }
}

