/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.markup;

import org.apache.isis.applib.value.Markup;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ValueModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.markup.MarkupComponent;
import org.apache.isis.viewer.wicket.ui.components.scalars.markup.MarkupComponentFactory;
import org.apache.isis.viewer.wicket.ui.components.scalars.markup.ParentedMarkupPanel;
import org.apache.isis.viewer.wicket.ui.components.scalars.markup.StandaloneMarkupPanel;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class MarkupPanelFactories {
    public static ComponentFactory parented() {
        return new Parented();
    }

    public static ComponentFactory standalone() {
        return new Standalone();
    }

    static class Standalone
    extends StandaloneAbstract {
        private static final long serialVersionUID = 1L;

        public Standalone() {
            super(Markup.class);
        }

        @Override
        protected MarkupComponentFactory getMarkupComponentFactory() {
            return MarkupComponent::new;
        }
    }

    static class Parented
    extends ParentedAbstract {
        private static final long serialVersionUID = 1L;

        public Parented() {
            super(Markup.class);
        }

        @Override
        protected MarkupComponentFactory getMarkupComponentFactory() {
            return (id, model) -> {
                MarkupComponent markupComponent = new MarkupComponent(id, model);
                markupComponent.setEnabled(false);
                return markupComponent;
            };
        }
    }

    public static abstract class StandaloneAbstract
    extends ComponentFactoryAbstract {
        private static final long serialVersionUID = 1L;
        private final Class<?> valueType;

        public StandaloneAbstract(Class<?> valueType) {
            super(ComponentType.VALUE, StandaloneMarkupPanel.class);
            this.valueType = valueType;
        }

        @Override
        public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
            if (!(model instanceof ValueModel)) {
                return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
            }
            ValueModel valueModel = (ValueModel)model;
            ManagedObject objectAdapter = (ManagedObject)valueModel.getObject();
            if (objectAdapter == null || objectAdapter.getPojo() == null) {
                return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
            }
            return this.appliesIf(this.valueType.isAssignableFrom(objectAdapter.getPojo().getClass()));
        }

        @Override
        public final Component createComponent(String id, IModel<?> model) {
            return new StandaloneMarkupPanel(id, (ValueModel)model, this.getMarkupComponentFactory());
        }

        protected abstract MarkupComponentFactory getMarkupComponentFactory();
    }

    public static abstract class ParentedAbstract
    extends ComponentFactoryAbstract {
        private static final long serialVersionUID = 1L;
        private final Class<?> valueType;

        public ParentedAbstract(Class<?> valueType) {
            super(ComponentType.SCALAR_NAME_AND_VALUE, ParentedMarkupPanel.class);
            this.valueType = valueType;
        }

        @Override
        public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
            if (!(model instanceof ScalarModel)) {
                return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
            }
            ScalarModel scalarModel = (ScalarModel)model;
            ObjectSpecification scalarSpec = scalarModel.getScalarTypeSpec();
            Class scalarType = scalarSpec.getCorrespondingClass();
            return this.appliesIf(scalarType.equals(this.valueType));
        }

        @Override
        public final Component createComponent(String id, IModel<?> model) {
            return new ParentedMarkupPanel(id, (ScalarModel)model, this.getMarkupComponentFactory());
        }

        protected abstract MarkupComponentFactory getMarkupComponentFactory();
    }
}

