/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.primitive;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkboxx.CheckBoxX;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkboxx.CheckBoxXConfig;
import java.io.Serializable;
import java.util.Optional;
import org.apache.isis.applib.annotation.LabelPosition;
import org.apache.isis.core.metamodel.facets.objectvalue.labelat.LabelAtFacet;
import org.apache.isis.viewer.wicket.model.models.BooleanModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.util.Tooltips;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class BooleanPanel
extends ScalarPanelAbstract {
    private static final long serialVersionUID = 1L;
    private CheckBoxX checkBox;

    public BooleanPanel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    @Override
    protected MarkupContainer createComponentForRegular() {
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        this.checkBox = Wkt.checkbox("scalarValue", (IModel<Boolean>)BooleanModel.forScalarModel((ScalarModel)scalarModel), scalarModel.isRequired(), CheckBoxXConfig.Sizes.lg);
        this.checkBox.setLabel((IModel)Model.of((Serializable)((Object)scalarModel.getFriendlyName())));
        FormGroup scalarIfRegularFormGroup = new FormGroup("scalarIfRegular", (FormComponent<?>)this.checkBox);
        scalarIfRegularFormGroup.add(new Component[]{this.checkBox});
        if (scalarModel.isRequired() && scalarModel.isEnabled()) {
            Wkt.cssAppend(scalarIfRegularFormGroup, "mandatory");
        }
        Label scalarNameLabel = this.createScalarName("scalarName", this.getRendering().getLabelCaption((LabeledWebMarkupContainer)this.checkBox));
        scalarIfRegularFormGroup.add(new Component[]{scalarNameLabel});
        scalarModel.getDescribedAs().ifPresent(describedAs -> Tooltips.addTooltip((Component)scalarIfRegularFormGroup, describedAs));
        return scalarIfRegularFormGroup;
    }

    @Override
    protected Component getScalarValueComponent() {
        return this.checkBox;
    }

    @Override
    protected Component createComponentForCompact() {
        CheckBoxX checkbox = Wkt.checkbox("scalarIfCompact", (IModel<Boolean>)BooleanModel.forScalarModel((ScalarModel)this.scalarModel()), this.scalarModel().isRequired(), CheckBoxXConfig.Sizes.sm);
        checkbox.setEnabled(false);
        return checkbox;
    }

    @Override
    protected ScalarPanelAbstract.InlinePromptConfig getInlinePromptConfig() {
        return ScalarPanelAbstract.InlinePromptConfig.supportedAndHide((Component)(this.scalarModel().mustBeEditable() ? this.checkBox : null));
    }

    @Override
    protected IModel<String> obtainInlinePromptModel() {
        return BooleanModel.forScalarModel((ScalarModel)this.scalarModel()).asStringModel("(not set)", "Yes", "No");
    }

    @Override
    protected void onInitializeEditable() {
        super.onInitializeEditable();
        this.checkBox.setEnabled(true);
    }

    @Override
    protected void onInitializeNotEditable() {
        super.onInitializeNotEditable();
        this.checkBox.setEnabled(false);
    }

    @Override
    protected void onInitializeReadonly(String disableReason) {
        super.onInitializeReadonly(disableReason);
        this.checkBox.setEnabled(false);
        this.checkBox.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)(disableReason != null ? disableReason : ""))))});
    }

    @Override
    protected void onNotEditable(String disableReason, Optional<AjaxRequestTarget> target) {
        this.checkBox.setEnabled(false);
        AttributeModifier title = new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)(disableReason != null ? disableReason : ""))));
        this.checkBox.add(new Behavior[]{title});
        target.ifPresent(ajax -> ajax.add(new Component[]{this.checkBox}));
    }

    @Override
    protected void onEditable(Optional<AjaxRequestTarget> target) {
        this.checkBox.setEnabled(true);
    }

    public String getVariation() {
        LabelAtFacet labelAtFacet = (LabelAtFacet)((ScalarModel)this.getModel()).getFacet(LabelAtFacet.class);
        return labelAtFacet != null && labelAtFacet.label() == LabelPosition.RIGHT ? "labelRightPosition" : super.getVariation();
    }
}

