/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.reference;

import java.io.Serializable;
import java.util.Optional;
import org.apache.isis.core.metamodel.facets.object.autocomplete.AutoCompleteFacet;
import org.apache.isis.core.metamodel.objectmanager.memento.ObjectMemento;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.common.model.object.ObjectUiModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelSelectAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.reference.EntityLinkSelect2Panel;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.components.widgets.entitysimplelink.EntityLinkSimplePanel;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.Select2;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ObjectAdapterMementoProviderForReferenceChoices;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ObjectAdapterMementoProviderForReferenceObjectAutoComplete;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ObjectAdapterMementoProviderForReferenceParamOrPropertyAutoComplete;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.Tooltips;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Settings;

public class ReferencePanel
extends ScalarPanelSelectAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_AUTO_COMPLETE = "autoComplete";
    private static final String ID_ENTITY_ICON_TITLE = "entityIconAndTitle";
    private EntityLinkSelect2Panel entityLink;
    private EntityLinkSimplePanel entitySimpleLink;

    public ReferencePanel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    Select2 getSelect2() {
        return this.select2;
    }

    @Override
    protected Component createComponentForCompact() {
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        String name = scalarModel.getFriendlyName();
        this.entitySimpleLink = (EntityLinkSimplePanel)this.getComponentFactoryRegistry().createComponent(ComponentType.ENTITY_LINK, (IModel<?>)scalarModel);
        this.entitySimpleLink.setOutputMarkupId(true);
        this.entitySimpleLink.setLabel((IModel)Model.of((Serializable)((Object)name)));
        WebMarkupContainer labelIfCompact = new WebMarkupContainer("scalarIfCompact");
        labelIfCompact.add(new Component[]{this.entitySimpleLink});
        return labelIfCompact;
    }

    protected FormGroup createComponentForRegular() {
        this.entityLink = new EntityLinkSelect2Panel(ComponentType.ENTITY_LINK.getId(), this);
        this.entityLink.setRequired(((ScalarModel)this.getModel()).isRequired());
        this.select2 = this.createSelect2AndSemantics();
        this.entityLink.addOrReplace(new Component[]{this.select2.asComponent()});
        this.entityLink.setOutputMarkupId(true);
        EntityLinkSelect2Panel formComponent = this.entityLink;
        return this.createFormGroup((FormComponent<?>)formComponent);
    }

    private Select2 createSelect2AndSemantics() {
        Select2 select2 = this.createSelect2(ID_AUTO_COMPLETE);
        Settings settings = select2.getSettings();
        if (((ScalarModel)this.getModel()).hasChoices()) {
            settings.setPlaceholder((Object)((ScalarModel)this.getModel()).getFriendlyName());
        } else if (((ScalarModel)this.getModel()).hasAutoComplete()) {
            int minLength = ((ScalarModel)this.getModel()).getAutoCompleteMinLength();
            settings.setMinimumInputLength(Integer.valueOf(minLength));
            settings.setPlaceholder((Object)((ScalarModel)this.getModel()).getFriendlyName());
        } else if (this.hasObjectAutoComplete()) {
            ObjectSpecification typeOfSpecification = ((ScalarModel)this.getModel()).getScalarTypeSpec();
            AutoCompleteFacet autoCompleteFacet = (AutoCompleteFacet)typeOfSpecification.getFacet(AutoCompleteFacet.class);
            int minLength = autoCompleteFacet.getMinLength();
            settings.setMinimumInputLength(Integer.valueOf(minLength));
        }
        return select2;
    }

    @Override
    protected ScalarPanelAbstract.InlinePromptConfig getInlinePromptConfig() {
        return ScalarPanelAbstract.InlinePromptConfig.supportedAndHide(this.select2.asComponent());
    }

    @Override
    protected IModel<String> obtainInlinePromptModel() {
        return this.select2.obtainInlinePromptModel();
    }

    @Override
    protected void onInitializeEditable() {
        super.onInitializeEditable();
        this.entityLink.setEnabled(true);
        this.syncWithInput();
    }

    @Override
    protected void onInitializeNotEditable() {
        super.onInitializeNotEditable();
        this.entityLink.setEnabled(false);
        this.syncWithInput();
    }

    @Override
    protected void onInitializeReadonly(String disableReason) {
        super.onInitializeReadonly(disableReason);
        ObjectUiModel.HasRenderingHints entityLinkModel = (ObjectUiModel.HasRenderingHints)this.entityLink.getModel();
        entityLinkModel.toViewMode();
        this.entityLink.setEnabled(false);
        Tooltips.addTooltip((Component)this.entityLink, disableReason);
        this.syncWithInput();
    }

    @Override
    protected void onNotEditable(String disableReason, Optional<AjaxRequestTarget> target) {
        super.onNotEditable(disableReason, target);
        this.entityLink.setEnabled(false);
        this.entityLink.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)disableReason)))});
    }

    @Override
    protected void onEditable(Optional<AjaxRequestTarget> target) {
        super.onEditable(target);
        this.entityLink.setEnabled(true);
        this.entityLink.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)"")))});
    }

    private void syncWithInput() {
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        ManagedObject adapter = scalarModel.getObject();
        MarkupContainer componentForRegular = (MarkupContainer)this.getComponentForRegular();
        if (componentForRegular != null) {
            ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(ComponentType.ENTITY_ICON_AND_TITLE, (IModel<?>)scalarModel);
            Component component = componentFactory.createComponent(ComponentType.ENTITY_ICON_AND_TITLE.getId(), (IModel<?>)scalarModel);
            componentForRegular.addOrReplace(new Component[]{component});
            boolean isInlinePrompt = scalarModel.isInlinePrompt();
            if (isInlinePrompt) {
                Wkt.cssAppend(component, "inlinePrompt");
            }
            if (adapter != null || isInlinePrompt) {
                Components.permanentlyHide(componentForRegular, "entityTitleIfNull");
            } else {
                Wkt.labelAdd(componentForRegular, "entityTitleIfNull", "(none)");
            }
        }
        if (this.isEditableWithEitherAutoCompleteOrChoices()) {
            if (this.select2 == null) {
                throw new IllegalStateException("select2 should be created already");
            }
            this.select2.clearInput();
            if (componentForRegular != null) {
                Components.permanentlyHide(componentForRegular, ID_ENTITY_ICON_TITLE);
                Components.permanentlyHide(componentForRegular, "entityTitleIfNull");
            }
            if (this.select2 != null) {
                boolean mutability = this.entityLink.isEnableAllowed() && !((ScalarModel)this.getModel()).isViewMode();
                this.select2.setEnabled(mutability);
            }
            Components.permanentlyHide((MarkupContainer)this.entityLink, "entityLinkIfNull");
        } else {
            Components.permanentlyHide((MarkupContainer)this.entityLink, ID_AUTO_COMPLETE);
        }
    }

    @Override
    protected ChoiceProvider<ObjectMemento> buildChoiceProvider() {
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        if (scalarModel.hasChoices()) {
            return new ObjectAdapterMementoProviderForReferenceChoices(scalarModel);
        }
        if (scalarModel.hasAutoComplete()) {
            return new ObjectAdapterMementoProviderForReferenceParamOrPropertyAutoComplete(scalarModel);
        }
        return new ObjectAdapterMementoProviderForReferenceObjectAutoComplete(scalarModel);
    }

    @Override
    protected void syncIfNull(Select2 select2) {
        if (((ScalarModel)this.getModel()).isScalar() && select2.isEmpty()) {
            select2.clear();
            ((ScalarModel)this.getModel()).setObject(null);
        }
    }

    String getInput() {
        ManagedObject pendingElseCurrentAdapter = ((ScalarModel)this.getModel()).getObject();
        return pendingElseCurrentAdapter != null ? pendingElseCurrentAdapter.titleString() : "(no object)";
    }

    void convertInput() {
        if (this.isEditableWithEitherAutoCompleteOrChoices()) {
            ManagedObject adapter = this.select2.getConvertedInputValue();
            ((ScalarModel)this.getModel()).setObject(adapter);
            ((ScalarModel)this.getModel()).clearPending();
        }
        ManagedObject pendingAdapter = ((ScalarModel)this.getModel()).getObject();
        this.entityLink.setConvertedInput(pendingAdapter);
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, ScalarPanelAbstract scalarPanel) {
        super.onUpdate(target, scalarPanel);
        Wkt.javaScriptAdd(target, Wkt.EventTopic.CLOSE_SELECT2, this.getMarkupId());
    }

    private boolean isEditableWithEitherAutoCompleteOrChoices() {
        if (((ScalarModel)this.getModel()).getRenderingHint().isInTable()) {
            return false;
        }
        if (((ScalarModel)this.getModel()).isViewMode()) {
            return false;
        }
        return ((ScalarModel)this.getModel()).hasChoices() || ((ScalarModel)this.getModel()).hasAutoComplete() || this.hasObjectAutoComplete();
    }

    private boolean hasObjectAutoComplete() {
        ObjectSpecification typeOfSpecification = ((ScalarModel)this.getModel()).getScalarTypeSpec();
        AutoCompleteFacet autoCompleteFacet = typeOfSpecification != null ? (AutoCompleteFacet)typeOfSpecification.getFacet(AutoCompleteFacet.class) : null;
        return autoCompleteFacet != null;
    }
}

