/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.string;

import java.io.Serializable;
import org.apache.isis.core.metamodel.facets.SingleIntValueFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.multiline.MultiLineFacet;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelTextFieldTextualAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;

public class MultiLineStringPanel
extends ScalarPanelTextFieldTextualAbstract {
    private static final long serialVersionUID = 1L;

    public MultiLineStringPanel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    @Override
    protected AbstractTextComponent<String> createTextField(String id) {
        TextArea textArea = new TextArea(id, this.newTextFieldValueModel());
        this.setRowsAndMaxLengthAttributesOn((TextArea<String>)textArea);
        return textArea;
    }

    @Override
    protected String createTextFieldFragmentId() {
        return "textarea";
    }

    @Override
    protected Component createInlinePromptComponent(String id, IModel<String> inlinePromptModel) {
        Fragment fragment = new Fragment(id, "textareaInlinePrompt", (MarkupContainer)this);
        TextArea<String> inlinePromptTextArea = Wkt.textAreaAddNoTab((MarkupContainer)fragment, "scalarValue", inlinePromptModel);
        this.setRowsAndMaxLengthAttributesOn(inlinePromptTextArea);
        return fragment;
    }

    @Override
    protected String obtainInlinePromptLinkCssIfAny() {
        return null;
    }

    private void setRowsAndMaxLengthAttributesOn(TextArea<String> textField) {
        Integer maxLength;
        MultiLineFacet multiLineFacet = (MultiLineFacet)((ScalarModel)this.getModel()).getFacet(MultiLineFacet.class);
        if (multiLineFacet != null) {
            this.setAttribute(textField, "rows", multiLineFacet.numberOfLines());
        }
        if ((maxLength = MultiLineStringPanel.getValueOf((ScalarModel)this.getModel(), MaxLengthFacet.class)) != null) {
            this.setAttribute(textField, "maxlength", maxLength);
        }
    }

    private Component setAttribute(TextArea<String> textField, String attributeName, int i) {
        return textField.add(new Behavior[]{AttributeModifier.replace((String)attributeName, (Serializable)((Object)("" + i)))});
    }

    private static Integer getValueOf(ScalarModel model, Class<? extends SingleIntValueFacet> facetType) {
        SingleIntValueFacet facet = (SingleIntValueFacet)model.getFacet(facetType);
        return facet != null ? Integer.valueOf(facet.value()) : null;
    }
}

