/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.valuechoices;

import java.util.Optional;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.objectmanager.memento.ObjectMemento;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelSelectAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.Select2;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ObjectAdapterMementoProviderForValueChoices;
import org.apache.isis.viewer.wicket.ui.util.Tooltips;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.wicketstuff.select2.AbstractSelect2Choice;
import org.wicketstuff.select2.ChoiceProvider;

public class ValueChoicesSelect2Panel
extends ScalarPanelSelectAbstract {
    private static final long serialVersionUID = 1L;

    public ValueChoicesSelect2Panel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    @Override
    protected Component createComponentForCompact() {
        return Wkt.label("scalarIfCompact", "placeholder");
    }

    @Override
    protected MarkupContainer createComponentForRegular() {
        if (this.select2 == null) {
            this.select2 = this.createSelect2("scalarValue");
        } else {
            this.select2.clearInput();
        }
        AbstractSelect2Choice<ObjectMemento, ?> formComponent = this.select2.asComponent();
        return this.createFormGroup((FormComponent<?>)formComponent);
    }

    @Override
    protected ScalarPanelAbstract.InlinePromptConfig getInlinePromptConfig() {
        return ScalarPanelAbstract.InlinePromptConfig.supportedAndHide(this.select2.asComponent());
    }

    @Override
    protected IModel<String> obtainInlinePromptModel() {
        return this.select2.obtainInlinePromptModel2();
    }

    @Override
    protected void onInitializeNotEditable() {
        this.select2.setEnabled(false);
    }

    @Override
    protected void onInitializeEditable() {
        this.select2.setEnabled(true);
        this.clearTitleAttribute();
    }

    @Override
    protected void onInitializeReadonly(String disableReason) {
        super.onInitializeReadonly(disableReason);
        this.setTitleAttribute(disableReason);
        this.select2.setEnabled(false);
    }

    private void clearTitleAttribute() {
        Component target = this.getComponentForRegular();
        Tooltips.clearTooltip(target);
    }

    private void setTitleAttribute(String titleAttribute) {
        if (_Strings.isNullOrEmpty((CharSequence)titleAttribute)) {
            this.clearTitleAttribute();
            return;
        }
        Component target = this.getComponentForRegular();
        Tooltips.addTooltip(target, titleAttribute);
    }

    @Override
    protected void onNotEditable(String disableReason, Optional<AjaxRequestTarget> target) {
        super.onNotEditable(disableReason, target);
        this.setTitleAttribute(disableReason);
        this.select2.setEnabled(false);
    }

    @Override
    protected void onEditable(Optional<AjaxRequestTarget> target) {
        super.onEditable(target);
        this.setTitleAttribute("");
        this.select2.setEnabled(true);
    }

    @Override
    protected ChoiceProvider<ObjectMemento> buildChoiceProvider() {
        return new ObjectAdapterMementoProviderForValueChoices(this.scalarModel());
    }

    @Override
    protected void syncIfNull(Select2 select2) {
        if (this.scalarModel().isEmpty()) {
            select2.clear();
        }
    }
}

