/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.standalonecollection;

import java.io.Serializable;
import java.util.List;
import org.apache.isis.applib.Identifier;
import org.apache.isis.core.metamodel.interactions.managed.nonscalar.DataTableModel;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModelStandalone;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.components.collection.count.CollectionCountProvider;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorHelper;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorProvider;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class StandaloneCollectionPanel
extends PanelAbstract<DataTableModel, EntityCollectionModel>
implements CollectionCountProvider,
CollectionSelectorProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_STANDALONE_COLLECTION = "standaloneCollection";
    private static final String ID_ACTION_NAME = "actionName";
    private static final String ID_SELECTOR_DROPDOWN = "selectorDropdown";
    private final CollectionSelectorPanel selectorDropdownPanel;
    private MarkupContainer outerDiv = new WebMarkupContainer("standaloneCollection");

    public StandaloneCollectionPanel(String id, EntityCollectionModelStandalone collectionModel) {
        super(id, collectionModel);
        this.addOrReplace(new Component[]{this.outerDiv});
        DataTableModel table = collectionModel.getDataTableModel();
        Identifier featureId = collectionModel.getIdentifier();
        Wkt.labelAdd(this.outerDiv, ID_ACTION_NAME, (String)table.getTitle().getValue());
        Wkt.cssAppend(this.outerDiv, featureId);
        Wkt.cssAppend(this.outerDiv, collectionModel.getElementType().getFeatureIdentifier());
        CollectionSelectorHelper selectorHelper = new CollectionSelectorHelper((EntityCollectionModel)collectionModel, this.getComponentFactoryRegistry());
        List<ComponentFactory> componentFactories = selectorHelper.getComponentFactories();
        if (componentFactories.size() <= 1) {
            Components.permanentlyHide(this.outerDiv, ID_SELECTOR_DROPDOWN);
            this.selectorDropdownPanel = null;
        } else {
            CollectionSelectorPanel selectorDropdownPanel = new CollectionSelectorPanel(ID_SELECTOR_DROPDOWN, (EntityCollectionModel)collectionModel);
            Model componentFactoryModel = new Model();
            String selected = selectorHelper.honourViewHintElseDefault((Component)selectorDropdownPanel);
            ComponentFactory selectedComponentFactory = selectorHelper.find(selected);
            componentFactoryModel.setObject((Serializable)selectedComponentFactory);
            this.outerDiv.setOutputMarkupId(true);
            this.outerDiv.addOrReplace(new Component[]{selectorDropdownPanel});
            this.selectorDropdownPanel = selectorDropdownPanel;
        }
        this.getComponentFactoryRegistry().addOrReplaceComponent(this.outerDiv, ComponentType.COLLECTION_CONTENTS, (IModel<?>)collectionModel);
    }

    @Override
    public CollectionSelectorPanel getSelectorDropdownPanel() {
        return this.selectorDropdownPanel;
    }

    @Override
    public Integer getCount() {
        EntityCollectionModel model = (EntityCollectionModel)this.getModel();
        return model.getElementCount();
    }
}

