/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.tree;

import org.apache.isis.applib.graph.tree.TreeNode;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ValueModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.isis.viewer.wicket.ui.components.tree.ParentedTreePanel;
import org.apache.isis.viewer.wicket.ui.components.tree.StandaloneTreePanel;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class TreePanelFactories {
    public static ComponentFactory parented() {
        return new Parented();
    }

    public static ComponentFactory standalone() {
        return new Standalone();
    }

    static class Standalone
    extends ComponentFactoryAbstract {
        private static final long serialVersionUID = 1L;

        public Standalone() {
            super(ComponentType.VALUE, StandaloneTreePanel.class);
        }

        @Override
        public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
            if (!(model instanceof ValueModel)) {
                return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
            }
            ValueModel valueModel = (ValueModel)model;
            ManagedObject adapter = (ManagedObject)valueModel.getObject();
            if (adapter == null || adapter.getPojo() == null) {
                return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
            }
            return this.appliesIf(adapter.getPojo() instanceof TreeNode);
        }

        @Override
        public final Component createComponent(String id, IModel<?> model) {
            return new StandaloneTreePanel(id, (ValueModel)model);
        }
    }

    static class Parented
    extends ComponentFactoryAbstract {
        private static final long serialVersionUID = 1L;

        public Parented() {
            super(ComponentType.SCALAR_NAME_AND_VALUE, ParentedTreePanel.class);
        }

        @Override
        public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
            if (!(model instanceof ScalarModel)) {
                return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
            }
            ScalarModel scalarModel = (ScalarModel)model;
            if (!scalarModel.isScalarTypeSubtypeOf(TreeNode.class)) {
                return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
            }
            return this.appliesIf(!scalarModel.hasChoices());
        }

        @Override
        public final Component createComponent(String id, IModel<?> model) {
            return new ParentedTreePanel(id, (ScalarModel)model);
        }
    }
}

