/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.buttons;

import java.io.Serializable;
import java.util.List;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ContainedButtonPanel
extends PanelAbstract<String, Model<String>> {
    private static final long serialVersionUID = 1L;
    private static final String ID_CONTAINER = "container";
    private static final String ID_FORM = "form";
    private static final String ID_BUTTON = "button";
    private final Button button;
    private final List<Component> componentsToRerender = _Lists.newArrayList();

    public ContainedButtonPanel(String id, String caption) {
        super(id, Model.of((Serializable)((Object)caption)));
        WebMarkupContainer markupContainer = new WebMarkupContainer(ID_CONTAINER);
        this.add(new Component[]{markupContainer});
        Form form = new Form(ID_FORM);
        markupContainer.add(new Component[]{form});
        this.button = new AjaxButton(ID_BUTTON, (IModel)this.getModel()){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                this.setDefaultFormProcessing(false);
                ContainedButtonPanel.this.onSubmit();
                if (target != null) {
                    for (Component component : ContainedButtonPanel.this.componentsToRerender) {
                        Components.addToAjaxRequest(target, component);
                    }
                }
            }
        };
        form.add(new Component[]{this.button});
    }

    public void addComponentToRerender(Component component) {
        component.setOutputMarkupPlaceholderTag(true);
        this.componentsToRerender.add(component);
    }

    public void setCaption(String string) {
        this.button.setModelValue(new String[]{string});
    }

    public void setLabel(Model<String> labelModel) {
        this.button.setLabel(labelModel);
    }

    public void onSubmit() {
    }
}

