/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.entitysimplelink;

import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.components.widgets.formcomponent.CancelHintRequired;
import org.apache.isis.viewer.wicket.ui.components.widgets.formcomponent.FormComponentPanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.model.IModel;

public class EntityLinkSimplePanel
extends FormComponentPanelAbstract<ManagedObject>
implements CancelHintRequired {
    private static final long serialVersionUID = 1L;
    private static final String ID_ENTITY_ICON_AND_TITLE = "entityIconAndTitle";
    private static final String ID_ENTITY_TITLE_NULL = "entityTitleNull";

    public EntityLinkSimplePanel(String id, IModel<ManagedObject> model) {
        super(id, model);
        _Assert.assertTrue((boolean)(model instanceof IsisAppCommonContext.HasCommonContext));
        this.setType(ManagedObject.class);
        this.buildGui();
    }

    private boolean isEmpty() {
        return ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)((ManagedObject)this.getModel().getObject()));
    }

    private void buildGui() {
        this.syncWithInput();
    }

    protected void onBeforeRender() {
        this.syncWithInput();
        super.onBeforeRender();
    }

    private void syncWithInput() {
        if (this.isEmpty()) {
            Wkt.labelAdd((MarkupContainer)this, ID_ENTITY_TITLE_NULL, "(none)");
            this.permanentlyHide(ID_ENTITY_TITLE_NULL);
            this.permanentlyHide(ID_ENTITY_ICON_AND_TITLE);
        } else {
            IModel objectModelForLink = this.getModel();
            ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(ComponentType.ENTITY_ICON_AND_TITLE, objectModelForLink);
            Component component = componentFactory.createComponent(ID_ENTITY_ICON_AND_TITLE, objectModelForLink);
            this.addOrReplace(new Component[]{component});
            this.permanentlyHide(ID_ENTITY_TITLE_NULL);
        }
    }

    @Override
    public void onCancel() {
    }

    public void validate() {
    }
}

