/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.formcomponent;

import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;

public abstract class FormComponentPanelAbstract<T>
extends FormComponentPanel<T> {
    private static final long serialVersionUID = 1L;
    private ComponentType componentType;

    public FormComponentPanelAbstract(String id, IModel<T> model) {
        super(id, model);
        this.componentType = ComponentType.lookup((String)id);
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    protected Component addOrReplace(ComponentType componentType, IModel<?> model) {
        return this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, componentType, model);
    }

    protected void permanentlyHide(ComponentType ... componentIds) {
        this.permanentlyHide((MarkupContainer)this, componentIds);
    }

    public void permanentlyHide(String ... ids) {
        this.permanentlyHide((MarkupContainer)this, ids);
    }

    protected void permanentlyHide(MarkupContainer container, ComponentType ... componentIds) {
        Components.permanentlyHide(container, componentIds);
    }

    public void permanentlyHide(MarkupContainer container, String ... ids) {
        Components.permanentlyHide(container, ids);
    }

    public UiHintContainer getHintContainer() {
        return this.hintContainerOf((Component)this);
    }

    private UiHintContainer hintContainerOf(Component component) {
        if (component == null) {
            return null;
        }
        IModel model = component.getDefaultModel();
        if (model instanceof UiHintContainer) {
            return (UiHintContainer)model;
        }
        return this.hintContainerOf((Component)this.getParent());
    }

    protected ComponentFactoryRegistry getComponentFactoryRegistry() {
        ComponentFactoryRegistryAccessor cfra = (ComponentFactoryRegistryAccessor)this.getApplication();
        return cfra.getComponentFactoryRegistry();
    }
}

