/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.linkandlabel;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import java.io.Serializable;
import lombok.NonNull;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.debug._Probe;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettingsAccessor;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.ActionPromptWithExtraContent;
import org.apache.isis.viewer.wicket.model.models.FormExecutor;
import org.apache.isis.viewer.wicket.model.models.FormExecutorContext;
import org.apache.isis.viewer.wicket.model.models.InlinePromptContext;
import org.apache.isis.viewer.wicket.model.util.CommonContextUtils;
import org.apache.isis.viewer.wicket.model.util.PageParameterUtils;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.components.actions.ActionParametersPanel;
import org.apache.isis.viewer.wicket.ui.components.layout.bs3.BS3GridPanel;
import org.apache.isis.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.isis.viewer.wicket.ui.panels.FormExecutorDefault;
import org.apache.isis.viewer.wicket.ui.panels.PanelUtil;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.AjaxIndicatorAppender;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;

public final class ActionLink
extends IndicatingAjaxLink<ManagedObject> {
    private static final long serialVersionUID = 1L;
    private final AjaxIndicatorAppender indicatorAppenderIfAny;
    protected transient IsisAppCommonContext commonContext;

    public static ActionLink create(@NonNull String linkId, @NonNull ActionModel actionModel) {
        if (linkId == null) {
            throw new NullPointerException("linkId is marked non-null but is null");
        }
        if (actionModel == null) {
            throw new NullPointerException("actionModel is marked non-null but is null");
        }
        ActionLink actionLink = new ActionLink(linkId, actionModel);
        return Wkt.cssAppend(actionLink, "noVeil");
    }

    private ActionLink(String id, ActionModel model) {
        super(id, (IModel)model);
        this.commonContext = model.getCommonContext();
        boolean useIndicatorForNoArgAction = this.getSettings().isUseIndicatorForNoArgAction();
        AjaxIndicatorAppender ajaxIndicatorAppender = this.indicatorAppenderIfAny = useIndicatorForNoArgAction ? new AjaxIndicatorAppender() : null;
        if (this.indicatorAppenderIfAny != null) {
            this.add(new Behavior[]{this.indicatorAppenderIfAny});
        }
    }

    ActionModel getActionModel() {
        return (ActionModel)this.getModel();
    }

    public ObjectAction getObjectAction() {
        return this.getActionModel().getAction();
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        if (this.getSettings().isPreventDoubleClickForNoArgAction()) {
            PanelUtil.disableBeforeReenableOnComplete(attributes, (Component)this);
        }
        attributes.setEventPropagation(AjaxRequestAttributes.EventPropagation.BUBBLE);
    }

    public String getReasonDisabledIfAny() {
        return this.isVisible() ? this.getActionModel().getUsabilityConsent().getReason() : null;
    }

    public boolean isVisible() {
        return this.getActionModel().getVisibilityConsent().isAllowed();
    }

    public boolean isEnabled() {
        return this.getActionModel().getUsabilityConsent().isAllowed();
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Buttons.fixDisabledState((Component)this, (ComponentTag)tag);
    }

    public String getAjaxIndicatorMarkupId() {
        return this.indicatorAppenderIfAny != null ? this.indicatorAppenderIfAny.getMarkupId() : null;
    }

    protected WicketViewerSettings getSettings() {
        return ((WicketViewerSettingsAccessor)Application.get()).getSettings();
    }

    public void onClick(AjaxRequestTarget target) {
        _Probe.entryPoint((_Probe.EntryPoint)_Probe.EntryPoint.USER_INTERACTION, (String)"Wicket Ajax Request, originating from User clicking an Action Link.");
        ActionModel actionModel = this.getActionModel();
        if (actionModel.getInlinePromptContext() == null || actionModel.getPromptStyle().isDialog()) {
            if (actionModel.hasParameters()) {
                this.startDialogWithParams(target);
            } else {
                this.executeWithoutParams();
            }
        } else {
            this.startDialogInline(target);
        }
    }

    private void startDialogWithParams(AjaxRequestTarget target) {
        ActionModel actionModel = this.getActionModel();
        ObjectSpecification actionOwnerSpec = actionModel.getActionOwner().getSpecification();
        ActionPrompt actionPrompt = ActionPromptProvider.getFrom((Page)this.getPage()).getActionPrompt(actionModel.getPromptStyle(), actionOwnerSpec.getBeanSort());
        ActionParametersPanel actionParametersPanel = (ActionParametersPanel)this.getComponentFactoryRegistry().createComponent(ComponentType.ACTION_PROMPT, actionPrompt.getContentId(), (IModel<?>)actionModel);
        actionParametersPanel.setShowHeader(false);
        Label label = Wkt.label(actionPrompt.getTitleId(), (IModel<String>)((IModel & Serializable)() -> ((ActionModel)actionModel).getFriendlyName()));
        actionPrompt.setTitle((Component)label, target);
        actionPrompt.setPanel((Component)actionParametersPanel, target);
        actionPrompt.showPrompt(target);
        _Casts.castTo(ActionPromptWithExtraContent.class, (Object)actionPrompt).ifPresent(promptWithExtraContent -> BS3GridPanel.extraContentForMixin(promptWithExtraContent.getExtraContentId(), actionModel).ifPresent(gridPanel -> promptWithExtraContent.setExtraContentPanel((Component)gridPanel, target)));
    }

    private void executeWithoutParams() {
        ActionModel actionModel = this.getActionModel();
        FormExecutor.FormExecutionOutcome outcome = FormExecutorDefault.forAction(actionModel).executeAndProcessResults(null, null, (FormExecutorContext)actionModel);
        if (outcome.isFailure()) {
            ManagedObject targetAdapter = actionModel.getParentObject();
            Bookmark bookmark = (Bookmark)targetAdapter.getBookmarkRefreshed().orElseThrow();
            this.getCommonContext().getTransactionService().flushTransaction();
            RequestCycle.get().setResponsePage(EntityPage.class, PageParameterUtils.createPageParametersForBookmark((Bookmark)bookmark));
        }
    }

    private void startDialogInline(AjaxRequestTarget target) {
        ActionModel actionModel = this.getActionModel();
        InlinePromptContext inlinePromptContext = actionModel.getInlinePromptContext();
        MarkupContainer scalarTypeContainer = inlinePromptContext.getScalarTypeContainer();
        this.getComponentFactoryRegistry().addOrReplaceComponent(scalarTypeContainer, "scalarIfRegularInlinePromptForm", ComponentType.PARAMETERS, (IModel<?>)actionModel);
        inlinePromptContext.getScalarIfRegular().setVisible(false);
        inlinePromptContext.getScalarIfRegularInlinePromptForm().setVisible(true);
        target.add(new Component[]{scalarTypeContainer});
    }

    public IsisAppCommonContext getCommonContext() {
        this.commonContext = CommonContextUtils.computeIfAbsent((IsisAppCommonContext)this.commonContext);
        return this.commonContext;
    }

    private ComponentFactoryRegistry getComponentFactoryRegistry() {
        return ((ComponentFactoryRegistryAccessor)Application.get()).getComponentFactoryRegistry();
    }
}

