/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.select2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.isis.commons.internal.base._Either;
import org.apache.isis.core.metamodel.objectmanager.memento.ObjectMemento;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModelWithMultiChoice;
import org.apache.isis.viewer.wicket.model.models.ScalarModelWithSingleChoice;
import org.apache.isis.viewer.wicket.model.util.CommonContextUtils;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.ChoiceExt;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.Select2ChoiceExt;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.Select2MultiChoiceExt;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LambdaModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidator;
import org.danekja.java.util.function.serializable.SerializableSupplier;
import org.wicketstuff.select2.AbstractSelect2Choice;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Settings;

public class Select2
implements Serializable,
IsisAppCommonContext.HasCommonContext {
    private static final long serialVersionUID = 1L;
    final _Either<Select2ChoiceExt, Select2MultiChoiceExt> select2Choice;
    private transient IsisAppCommonContext commonContext;

    public static Select2 createSelect2(String id, ScalarModel scalarModel) {
        return new Select2((_Either<Select2ChoiceExt, Select2MultiChoiceExt>)(!scalarModel.isCollection() ? _Either.left((Object)Select2ChoiceExt.create(id, (IModel<ObjectMemento>)ScalarModelWithSingleChoice.chain((ScalarModel)scalarModel), scalarModel)) : _Either.right((Object)Select2MultiChoiceExt.create(id, (IModel<ArrayList<ObjectMemento>>)ScalarModelWithMultiChoice.chain((ScalarModel)scalarModel), scalarModel))));
    }

    private Select2(@NonNull _Either<Select2ChoiceExt, Select2MultiChoiceExt> select2Choice) {
        if (select2Choice == null) {
            throw new NullPointerException("select2Choice is marked non-null but is null");
        }
        this.select2Choice = select2Choice;
    }

    public void setProvider(ChoiceProvider<ObjectMemento> providerForChoices) {
        this.asChoiceExt().setProvider(providerForChoices);
    }

    public AbstractSelect2Choice<ObjectMemento, ?> asComponent() {
        return (AbstractSelect2Choice)this.select2Choice.fold(single -> single, multi -> multi);
    }

    public ChoiceExt asChoiceExt() {
        return (ChoiceExt)this.select2Choice.fold(single -> single, multi -> multi);
    }

    public void clearInput() {
        this.asComponent().clearInput();
    }

    public void setEnabled(boolean mutability) {
        this.asComponent().setEnabled(mutability);
    }

    public void setRequired(boolean required) {
        this.asComponent().setRequired(required);
    }

    public boolean checkRequired() {
        return this.asComponent().checkRequired();
    }

    public Settings getSettings() {
        return this.asChoiceExt().getSettings();
    }

    public ManagedObject getConvertedInputValue() {
        return this.getCommonContext().reconstructObject(this.convertedInput());
    }

    public void setLabel(Model<String> model) {
        this.asComponent().setLabel(model);
    }

    public void add(Behavior behavior) {
        this.asComponent().add(new Behavior[]{behavior});
    }

    public final Select2 add(IValidator<Object> validator) {
        this.asComponent().add(validator);
        return this;
    }

    public <M extends Behavior> List<M> getBehaviors(Class<M> behaviorClass) {
        return this.asComponent().getBehaviors(behaviorClass);
    }

    public void remove(Behavior behavior) {
        this.asComponent().remove(new Behavior[]{behavior});
    }

    public void syncIfNull(ScalarModel model) {
        if (!model.isCollection() && this.memento() == null) {
            this.mementoModel().setObject(null);
            model.setObject(null);
        }
    }

    public boolean isEmpty() {
        ObjectMemento curr = this.memento();
        return curr == null;
    }

    public void clear() {
        this.mementoModel().setObject(null);
    }

    public IModel<String> obtainInlinePromptModel() {
        return LambdaModel.of((SerializableSupplier & Serializable)() -> {
            ObjectMemento memento = (ObjectMemento)this.mementoModel().getObject();
            if (memento == null) {
                return null;
            }
            ManagedObject adapter = this.getCommonContext().reconstructObject(memento);
            return adapter != null ? adapter.titleString() : null;
        });
    }

    public IModel<String> obtainInlinePromptModel2() {
        return LambdaModel.of((SerializableSupplier & Serializable)() -> {
            ObjectMemento inlinePromptMemento = this.memento();
            return inlinePromptMemento != null ? inlinePromptMemento.asString() : null;
        });
    }

    private ObjectMemento memento() {
        return (ObjectMemento)this.select2Choice.fold(single -> (ObjectMemento)single.getModelObject(), multi -> multi.getPackedModelObject());
    }

    private IModel<ObjectMemento> mementoModel() {
        return (IModel)this.select2Choice.fold(single -> single.getModel(), multi -> multi.getPackingAdapterModel());
    }

    private ObjectMemento convertedInput() {
        ObjectMemento convertedInput = (ObjectMemento)this.select2Choice.fold(single -> (ObjectMemento)single.getConvertedInput(), multi -> multi.getPackedConvertedInput());
        this.mementoModel().setObject((Object)convertedInput);
        return convertedInput;
    }

    public IsisAppCommonContext getCommonContext() {
        this.commonContext = CommonContextUtils.computeIfAbsent((IsisAppCommonContext)this.commonContext);
        return this.commonContext;
    }
}

