/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.isis.applib.id.LogicalType;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.metamodel.objectmanager.memento.ObjectMemento;
import org.apache.isis.core.metamodel.objectmanager.memento.ObjectMementoForEmpty;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.wicket.util.string.Strings;
import org.springframework.lang.Nullable;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.Response;

public abstract class ObjectAdapterMementoProviderAbstract
extends ChoiceProvider<ObjectMemento> {
    private static final long serialVersionUID = 1L;
    protected static final String NULL_PLACEHOLDER = "$$_isis_null_$$";
    private static final String NULL_DISPLAY_TEXT = "";
    private final ScalarModel scalarModel;
    private transient IsisAppCommonContext commonContext;
    private transient WicketViewerSettings wicketViewerSettings;

    public ObjectAdapterMementoProviderAbstract(ScalarModel scalarModel) {
        this.scalarModel = scalarModel;
    }

    public String getDisplayValue(ObjectMemento choiceMemento) {
        if (choiceMemento == null || choiceMemento instanceof ObjectMementoForEmpty) {
            return NULL_DISPLAY_TEXT;
        }
        ManagedObject choice = this.getCommonContext().reconstructObject(choiceMemento);
        if (ManagedObjects.isNullOrUnspecifiedOrEmpty((ManagedObject)choice)) {
            return "Internal error: broken memento " + choiceMemento;
        }
        return choice.titleString();
    }

    public String getIdValue(ObjectMemento choiceMemento) {
        if (choiceMemento == null) {
            return NULL_PLACEHOLDER;
        }
        LogicalType logicalType = choiceMemento.getLogicalType();
        ObjectSpecification spec = this.getCommonContext().getSpecificationLoader().specForLogicalType(logicalType).orElse(null);
        if (spec != null && spec.isValue()) {
            return logicalType.getLogicalTypeName() + ":" + choiceMemento.asString();
        }
        return choiceMemento.asString();
    }

    public void query(String term, int page, Response<ObjectMemento> response) {
        ArrayList mementos = _Lists.newArrayList(this.obtainMementos(term));
        if (!this.scalarModel.isRequired() && !mementos.contains(null)) {
            mementos.add(0, null);
        }
        response.addAll((Collection)mementos);
    }

    protected abstract Can<ObjectMemento> obtainMementos(String var1);

    protected final Can<ObjectMemento> obtainMementos(String term, Can<ObjectMemento> choicesMementos) {
        if (Strings.isEmpty((CharSequence)term)) {
            return choicesMementos;
        }
        IsisAppCommonContext commonContext = this.getCommonContext();
        return choicesMementos.filter(candidate -> {
            ManagedObject objectAdapter = commonContext.reconstructObject(candidate);
            String title = objectAdapter.titleString();
            return title.toLowerCase().contains(term.toLowerCase());
        });
    }

    public Collection<ObjectMemento> toChoices(Collection<String> ids) {
        return _NullSafe.stream(ids).map(this::idToMemento).collect(Collectors.toList());
    }

    public boolean dependsOnPreviousArgs() {
        return true;
    }

    protected IsisAppCommonContext getCommonContext() {
        if (this.commonContext == null) {
            this.commonContext = this.scalarModel.getCommonContext();
        }
        return this.commonContext;
    }

    protected WicketViewerSettings getWicketViewerSettings() {
        if (this.wicketViewerSettings == null) {
            this.wicketViewerSettings = (WicketViewerSettings)this.getCommonContext().lookupServiceElseFail(WicketViewerSettings.class);
        }
        return this.wicketViewerSettings;
    }

    @Nullable
    private ObjectMemento idToMemento(String id) {
        if (NULL_PLACEHOLDER.equals(id)) {
            return null;
        }
        ObjectMemento memento = Bookmark.parse((String)id).map(arg_0 -> ((IsisAppCommonContext)this.getCommonContext()).mementoForBookmark(arg_0)).orElse(null);
        return memento;
    }

    public ScalarModel getScalarModel() {
        return this.scalarModel;
    }
}

