/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers;

import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.metamodel.objectmanager.memento.ObjectMemento;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.common.model.feature.ParameterUiModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.providers.ObjectAdapterMementoProviderAbstract;

public class ObjectAdapterMementoProviderForReferenceParamOrPropertyAutoComplete
extends ObjectAdapterMementoProviderAbstract {
    private static final long serialVersionUID = 1L;

    public ObjectAdapterMementoProviderForReferenceParamOrPropertyAutoComplete(ScalarModel scalarModel) {
        super(scalarModel);
        if (!scalarModel.hasAutoComplete()) {
            throw _Exceptions.illegalArgument((String)"Cannot create auto-complete provider, when model has no auto-complete %s", (Object[])new Object[]{scalarModel});
        }
    }

    @Override
    protected Can<ObjectMemento> obtainMementos(String term) {
        IsisAppCommonContext commonContext = this.getCommonContext();
        ScalarModel scalarModel = this.getScalarModel();
        Can pendingArgs = scalarModel.isParameter() ? ((ParameterUiModel)scalarModel).getParameterNegotiationModel().getParamValues() : Can.empty();
        Can pendingArgMementos = pendingArgs.map(arg_0 -> ((IsisAppCommonContext)commonContext).mementoForParameter(arg_0));
        if (scalarModel.isParameter()) {
            ParameterUiModel paramModel = (ParameterUiModel)scalarModel;
            paramModel.getParameterNegotiationModel().setParamValues(this.reconstructPendingArgs(paramModel, (Can<ObjectMemento>)pendingArgMementos));
        }
        return scalarModel.getAutoComplete(term).map(arg_0 -> ((IsisAppCommonContext)commonContext).mementoFor(arg_0));
    }

    private Can<ManagedObject> reconstructPendingArgs(ParameterUiModel parameterModel, Can<ObjectMemento> pendingArgMementos) {
        IsisAppCommonContext commonContext = super.getCommonContext();
        Can pendingArgsList = (Can)_NullSafe.stream(pendingArgMementos).map(arg_0 -> ((IsisAppCommonContext)commonContext).reconstructObject(arg_0)).map(ManagedObject.class::cast).collect(Can.toCan());
        return pendingArgsList;
    }
}

