/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.themepicker;

import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.core.settings.ThemeProvider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wicket.util.string.Strings;

public class ThemeProviderComposite
implements ThemeProvider {
    private static final Logger log = LogManager.getLogger(ThemeProviderComposite.class);
    private final Can<ThemeProvider> themeProviders;
    private ITheme defaultTheme;
    private Map<String, ITheme> themesByName;
    private List<String> availableNames;
    private List<ITheme> availableThemes;

    public ITheme byName(String name) {
        if (!Strings.isEmpty((CharSequence)name)) {
            this.ensureInit();
            ITheme theme = this.themesByName.get(name.toLowerCase());
            if (theme != null) {
                return theme;
            }
        }
        log.warn("'{}' theme not found amoung providers {} provinding {}, using default '{}' instead", (Object)name, (Object)this.themeProviders.toList(), (Object)this.available().stream().map(ITheme::name).collect(Collectors.joining(", ")), (Object)this.defaultTheme().name());
        return this.defaultTheme();
    }

    public List<ITheme> available() {
        this.ensureInit();
        return this.availableThemes;
    }

    public ITheme defaultTheme() {
        this.ensureInit();
        return this.defaultTheme;
    }

    public List<String> availableNames() {
        this.ensureInit();
        return this.availableNames;
    }

    private void ensureInit() {
        if (this.themesByName != null) {
            return;
        }
        this.themesByName = _Maps.newLinkedHashMap();
        this.themeProviders.forEach(themeProvider -> {
            if (this.defaultTheme == null) {
                this.defaultTheme = themeProvider.defaultTheme();
            }
            themeProvider.available().forEach(theme -> this.themesByName.put(theme.name().toLowerCase(), (ITheme)theme));
        });
        this.availableThemes = Collections.unmodifiableList(_Lists.newArrayList(this.themesByName.values()));
        this.availableNames = Collections.unmodifiableList(_Lists.map(this.availableThemes, ITheme::name));
    }

    private ThemeProviderComposite(Can<ThemeProvider> themeProviders) {
        this.themeProviders = themeProviders;
    }

    public static ThemeProviderComposite of(Can<ThemeProvider> themeProviders) {
        return new ThemeProviderComposite(themeProviders);
    }
}

