/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.errors;

import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.wicket.model.util.CommonContextUtils;
import org.apache.isis.viewer.wicket.ui.errors.JGrowlUtil;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class JGrowlBehaviour
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private transient IsisAppCommonContext commonContext;

    public JGrowlBehaviour(IsisAppCommonContext commonContext) {
        this.commonContext = commonContext;
    }

    protected void respond(AjaxRequestTarget target) {
        IsisConfiguration configuration = this.getCommonContext().getConfiguration();
        this.getCommonContext().getMessageBroker().ifPresent(messageBroker -> {
            String feedbackMsg = JGrowlUtil.asJGrowlCalls(messageBroker, configuration);
            if (!_Strings.isNullOrEmpty((CharSequence)feedbackMsg)) {
                target.appendJavaScript((CharSequence)feedbackMsg);
            }
        });
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        this.renderFeedbackMessages(response);
    }

    public void renderFeedbackMessages(IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(JGrowlBehaviour.class, "js/bootstrap-growl.js")));
        IsisConfiguration configuration = this.getCommonContext().getConfiguration();
        this.getCommonContext().getMessageBroker().ifPresent(messageBroker -> {
            String feedbackMsg = JGrowlUtil.asJGrowlCalls(messageBroker, configuration);
            if (_Strings.isNotEmpty((CharSequence)feedbackMsg)) {
                response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)feedbackMsg));
            }
        });
    }

    protected IsisAppCommonContext getCommonContext() {
        this.commonContext = CommonContextUtils.computeIfAbsent((IsisAppCommonContext)this.commonContext);
        return this.commonContext;
    }
}

