/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.errors;

import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.core.interaction.session.MessageBroker;
import org.apache.wicket.util.string.Strings;

public class JGrowlUtil {
    private JGrowlUtil() {
    }

    public static String asJGrowlCalls(MessageBroker messageBroker, IsisConfiguration configuration) {
        StringBuilder buf = new StringBuilder();
        IsisConfiguration.Viewer.Wicket.MessagePopups messagePopups = configuration.getViewer().getWicket().getMessagePopups();
        for (String info : messageBroker.drainMessages()) {
            JGrowlUtil.addJGrowlCall(info, MessageSeverity.INFO, messagePopups, buf);
        }
        for (String warning : messageBroker.drainWarnings()) {
            JGrowlUtil.addJGrowlCall(warning, MessageSeverity.WARNING, messagePopups, buf);
        }
        messageBroker.drainApplicationError().ifPresent(error -> JGrowlUtil.addJGrowlCall(error, MessageSeverity.DANGER, messagePopups, buf));
        return buf.toString();
    }

    private static void addJGrowlCall(String origMsg, MessageSeverity severity, IsisConfiguration.Viewer.Wicket.MessagePopups messagePopups, StringBuilder buf) {
        String escapedMsg = JGrowlUtil.escape(origMsg);
        buf.append("$.growl(\"").append((CharSequence)escapedMsg).append("&#160;&#160;&#160;").append('\"');
        buf.append(", {");
        buf.append("type: \"").append(severity.cssClassSuffix()).append('\"');
        buf.append(String.format(", delay: %d", severity.delay(messagePopups)));
        buf.append(String.format(", placement: { from: '%s', align: '%s' }", messagePopups.getPlacement().getVertical().name().toLowerCase(), messagePopups.getPlacement().getHorizontal().name().toLowerCase()));
        buf.append(String.format(", offset: %d", messagePopups.getOffset()));
        buf.append('}');
        buf.append(");\n");
    }

    static String escape(String origMsg) {
        String escaped = Strings.escapeMarkup((CharSequence)origMsg).toString();
        return escaped.replace("&quot;", "'").replace("&#039;", "'");
    }

    static enum MessageSeverity {
        INFO{

            @Override
            long delay(IsisConfiguration.Viewer.Wicket.MessagePopups messagePopups) {
                return messagePopups.getInfoDelay().toMillis();
            }
        }
        ,
        WARNING{

            @Override
            long delay(IsisConfiguration.Viewer.Wicket.MessagePopups messagePopups) {
                return messagePopups.getWarningDelay().toMillis();
            }
        }
        ,
        DANGER{

            @Override
            long delay(IsisConfiguration.Viewer.Wicket.MessagePopups messagePopups) {
                return messagePopups.getErrorDelay().toMillis();
            }
        };


        public String cssClassSuffix() {
            return this.name().toLowerCase();
        }

        abstract long delay(IsisConfiguration.Viewer.Wicket.MessagePopups var1);
    }
}

