/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages;

import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.markup.html.references.BootstrapJavaScriptReference;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ITheme;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.isis.applib.annotation.PromptStyle;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerService;
import org.apache.isis.applib.services.metamodel.BeanSort;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.core.config.viewer.web.DialogMode;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.hints.IsisEnvelopeEvent;
import org.apache.isis.viewer.wicket.model.hints.IsisEventLetterAbstract;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.models.ActionPrompt;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.BookmarkableModel;
import org.apache.isis.viewer.wicket.model.models.BookmarkedPagesModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.components.actionprompt.ActionPromptModalWindow;
import org.apache.isis.viewer.wicket.ui.components.actionpromptsb.ActionPromptSidebar;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModelProvider;
import org.apache.isis.viewer.wicket.ui.errors.ExceptionModel;
import org.apache.isis.viewer.wicket.ui.errors.JGrowlBehaviour;
import org.apache.isis.viewer.wicket.ui.pages.BookmarkedPagesModelProvider;
import org.apache.isis.viewer.wicket.ui.pages.BootstrapOverridesCssResourceReference;
import org.apache.isis.viewer.wicket.ui.pages.SidebarCssResourceReference;
import org.apache.isis.viewer.wicket.ui.pages.WebPageBase;
import org.apache.isis.viewer.wicket.ui.util.FontAwesomeCssReferenceWkt;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.devutils.debugbar.DebugBar;
import org.apache.wicket.devutils.debugbar.IDebugBarContributor;
import org.apache.wicket.devutils.debugbar.InspectorDebugPanel;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.head.filter.HeaderResponseContainer;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.PackageResource;
import org.apache.wicket.request.resource.ResourceReference;

public abstract class PageAbstract
extends WebPageBase
implements ActionPromptProvider {
    private static final Logger log = LogManager.getLogger(PageAbstract.class);
    private static final long serialVersionUID = 1L;
    private static final JavaScriptResourceReference JQUERY_LIVEQUERY_JS = new JavaScriptResourceReference(PageAbstract.class, "jquery.livequery.js");
    private static final JavaScriptResourceReference JQUERY_ISIS_WICKET_VIEWER_JS = new JavaScriptResourceReference(PageAbstract.class, "jquery.isis.wicket.viewer.js");
    private static final String ID_THEME = "theme";
    private static final String ID_BOOKMARKED_PAGES = "bookmarks";
    private static final String ID_ACTION_PROMPT_MODAL_WINDOW = "actionPromptModalWindow";
    private static final String ID_ACTION_PROMPT_SIDEBAR = "actionPromptSidebar";
    private static final String ID_PAGE_TITLE = "pageTitle";
    public static final String ID_MENU_LINK = "menuLink";
    public static final String UIHINT_FOCUS = "focus";
    public static final ThreadLocal<ExceptionModel> EXCEPTION = new ThreadLocal();
    private final List<ComponentType> childComponentIds;
    protected MarkupContainer themeDiv;
    private ActionPromptModalWindow actionPromptModalWindow;
    private ActionPromptSidebar actionPromptSidebar;

    protected PageAbstract(PageParameters pageParameters, String title, ComponentType ... childComponentIds) {
        super(pageParameters);
        try {
            this.getSession().bind();
            this.setTitle(title);
            MarkupContainer header = this.createPageHeader("header");
            this.add(new Component[]{header});
            this.themeDiv = Wkt.containerAdd((MarkupContainer)this, ID_THEME);
            String applicationName = this.getConfiguration().getViewer().getWicket().getApplication().getName();
            Wkt.cssAppend(this.themeDiv, Wkt.cssNormalize(applicationName));
            boolean devUtilitiesEnabled = this.getApplication().getDebugSettings().isDevelopmentUtilitiesEnabled();
            DebugBar debugBar = devUtilitiesEnabled ? this.newDebugBar("debugBar") : new EmptyPanel("debugBar").setVisible(false);
            this.add(new Component[]{debugBar});
            MarkupContainer footer = this.createPageFooter("footer");
            this.themeDiv.add(new Component[]{footer});
            this.addActionPromptModalWindow(this.themeDiv);
            this.addActionPromptSidebar(this.themeDiv);
            this.childComponentIds = List.of(childComponentIds);
            this.add(new Component[]{new HeaderResponseContainer("footerJS", "footerJS")});
        }
        catch (RuntimeException ex) {
            log.error("Failed to construct page, going back to sign in page", (Throwable)ex);
            ExceptionRecognizerService exceptionRecognizerService = (ExceptionRecognizerService)this.getCommonContext().getServiceRegistry().lookupServiceElseFail(ExceptionRecognizerService.class);
            Optional recognition = exceptionRecognizerService.recognize((Throwable)ex);
            ExceptionModel exceptionModel = ExceptionModel.create(this.getCommonContext(), recognition, ex);
            this.getSession().invalidate();
            this.getSession().clear();
            EXCEPTION.set(exceptionModel);
            throw new RestartResponseAtInterceptPageException(this.getSignInPage());
        }
    }

    protected DebugBar newDebugBar(String id) {
        DebugBar debugBar = new DebugBar(id);
        List contributors = DebugBar.getContributors((Application)this.getApplication());
        Iterator iterator = contributors.iterator();
        while (iterator.hasNext()) {
            IDebugBarContributor contributor = (IDebugBarContributor)iterator.next();
            if (contributor != InspectorDebugPanel.DEBUG_BAR_CONTRIB) continue;
            iterator.remove();
        }
        return debugBar;
    }

    protected MarkupContainer createPageHeader(String id) {
        Component header = this.getComponentFactoryRegistry().createComponent(ComponentType.HEADER, id, null);
        return (MarkupContainer)header;
    }

    protected MarkupContainer createPageFooter(String id) {
        Component footer = this.getComponentFactoryRegistry().createComponent(ComponentType.FOOTER, id, null);
        return (MarkupContainer)footer;
    }

    protected void setTitle(String title) {
        Wkt.labelAdd((MarkupContainer)this, ID_PAGE_TITLE, title != null ? title : this.getConfiguration().getViewer().getWicket().getApplication().getName());
    }

    private Class<? extends Page> getSignInPage() {
        return this.getPageClassRegistry().getPageClass(PageType.SIGN_IN);
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        Component childComponent;
        String path;
        super.renderHead(response);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)this.getApplication().getJavaScriptLibrarySettings().getJQueryReference())));
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)BootstrapJavaScriptReference.instance())));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)FontAwesomeCssReferenceWkt.instance()));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new BootstrapOverridesCssResourceReference()));
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new SidebarCssResourceReference()));
        this.contributeThemeSpecificOverrides(response);
        response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)JQUERY_LIVEQUERY_JS));
        response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)JQUERY_ISIS_WICKET_VIEWER_JS));
        JGrowlBehaviour jGrowlBehaviour = new JGrowlBehaviour(this.getCommonContext());
        jGrowlBehaviour.renderFeedbackMessages(response);
        this.getConfiguration().getViewer().getWicket().getApplication().getCss().ifPresent(applicationCss -> response.render((HeaderItem)CssReferenceHeaderItem.forUrl((String)applicationCss)));
        this.getConfiguration().getViewer().getWicket().getApplication().getJs().ifPresent(applicationJs -> response.render((HeaderItem)JavaScriptReferenceHeaderItem.forUrl((String)applicationJs)));
        this.getConfiguration().getViewer().getWicket().getLiveReloadUrl().ifPresent(liveReloadUrl -> response.render((HeaderItem)JavaScriptReferenceHeaderItem.forUrl((String)liveReloadUrl)));
        if (this.getSystemEnvironment().isPrototyping()) {
            this.addBootLint(response);
        }
        String markupId = null;
        UiHintContainer hintContainer = this.getUiHintContainerIfAny();
        if (hintContainer != null && (path = hintContainer.getHint((Component)this.getPage(), UIHINT_FOCUS)) != null && (childComponent = this.get(path)) != null) {
            markupId = childComponent.getMarkupId();
        }
        Wkt.javaScriptAdd(response, Wkt.EventTopic.FOCUS_FIRST_PROPERTY, markupId);
    }

    protected UiHintContainer getUiHintContainerIfAny() {
        return null;
    }

    private void addBootLint(IHeaderResponse response) {
    }

    private void contributeThemeSpecificOverrides(IHeaderResponse response) {
        IBootstrapSettings bootstrapSettings = Bootstrap.getSettings((Application)this.getApplication());
        ITheme activeTheme = bootstrapSettings.getActiveThemeProvider().getActiveTheme();
        String name = activeTheme.name().toLowerCase(Locale.ENGLISH);
        String themeSpecificOverride = "bootstrap-overrides-" + name + ".css";
        ResourceReference.Key themeSpecificOverrideKey = new ResourceReference.Key(PageAbstract.class.getName(), themeSpecificOverride, null, null, null);
        if (PackageResource.exists((ResourceReference.Key)themeSpecificOverrideKey)) {
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(themeSpecificOverrideKey)));
        }
    }

    public List<ComponentType> getChildModelTypes() {
        return this.childComponentIds;
    }

    protected void addChildComponents(MarkupContainer container, IModel<?> model) {
        for (ComponentType componentType : this.getChildModelTypes()) {
            this.addComponent(container, componentType, model);
        }
    }

    private void addComponent(MarkupContainer container, ComponentType componentType, IModel<?> model) {
        this.getComponentFactoryRegistry().addOrReplaceComponent(container, componentType, model);
    }

    protected void addBookmarkedPages(MarkupContainer container) {
        Component bookmarks = this.getBookmarkedPagesModel().map(bm -> this.getComponentFactoryRegistry().createComponent(ComponentType.BOOKMARKED_PAGES, ID_BOOKMARKED_PAGES, (IModel<?>)bm)).orElseGet(() -> new EmptyPanel(ID_BOOKMARKED_PAGES).setVisible(false));
        container.add(new Component[]{bookmarks});
        bookmarks.add(new Behavior[]{new Behavior(){
            private static final long serialVersionUID = 1L;

            public void onConfigure(Component component) {
                super.onConfigure(component);
                PageParameters parameters = PageAbstract.this.getPageParameters();
                component.setVisible(parameters.get("isis.no.header").isNull());
            }
        }});
    }

    private boolean isShowBookmarks() {
        return this.getCommonContext().getConfiguration().getViewer().getWicket().getBookmarkedPages().isShowChooser();
    }

    protected boolean isShowBreadcrumbs() {
        return this.getCommonContext().getConfiguration().getViewer().getWicket().getBookmarkedPages().isShowDropDownOnFooter();
    }

    protected void bookmarkPageIfShown(BookmarkableModel model) {
        this.getBookmarkedPagesModel().ifPresent(bm -> bm.bookmarkPage(model));
    }

    protected void removeAnyBookmark(EntityModel model) {
        this.getBookmarkedPagesModel().ifPresent(bm -> bm.remove(model));
    }

    private Optional<BookmarkedPagesModel> getBookmarkedPagesModel() {
        return this.isShowBookmarks() ? _Casts.castTo(BookmarkedPagesModelProvider.class, (Object)this.getSession()).map(BookmarkedPagesModelProvider::getBookmarkedPagesModel) : Optional.empty();
    }

    protected Optional<BreadcrumbModel> getBreadcrumbModel() {
        return this.isShowBreadcrumbs() ? _Casts.castTo(BreadcrumbModelProvider.class, (Object)this.getSession()).map(BreadcrumbModelProvider::getBreadcrumbModel) : Optional.empty();
    }

    public ActionPrompt getActionPrompt(PromptStyle promptStyle, BeanSort sort) {
        switch (promptStyle) {
            default: {
                DialogMode dialogMode = sort.isManagedBean() ? this.getCommonContext().getConfiguration().getViewer().getWicket().getDialogModeForMenu() : this.getCommonContext().getConfiguration().getViewer().getWicket().getDialogMode();
                switch (dialogMode) {
                    case SIDEBAR: {
                        return this.actionPromptSidebar;
                    }
                }
                return this.actionPromptModalWindow;
            }
            case DIALOG_SIDEBAR: {
                return this.actionPromptSidebar;
            }
            case DIALOG_MODAL: 
        }
        return this.actionPromptModalWindow;
    }

    public void closePrompt(AjaxRequestTarget target) {
        this.actionPromptSidebar.closePrompt(target);
        this.actionPromptModalWindow.closePrompt(target);
    }

    private void addActionPromptModalWindow(MarkupContainer parent) {
        this.actionPromptModalWindow = ActionPromptModalWindow.newModalWindow(ID_ACTION_PROMPT_MODAL_WINDOW);
        parent.addOrReplace(new Component[]{this.actionPromptModalWindow});
    }

    private void addActionPromptSidebar(MarkupContainer parent) {
        this.actionPromptSidebar = ActionPromptSidebar.newSidebar(ID_ACTION_PROMPT_SIDEBAR);
        parent.addOrReplace(new Component[]{this.actionPromptSidebar});
    }

    public void onEvent(IEvent<?> event) {
        Object payload = event.getPayload();
        if (payload instanceof IsisEventLetterAbstract) {
            IsisEventLetterAbstract letter = (IsisEventLetterAbstract)payload;
            IsisEnvelopeEvent broadcastEv = new IsisEnvelopeEvent(letter);
            this.send((IEventSink)this, Broadcast.BREADTH, broadcastEv);
        }
    }

    protected ComponentFactoryRegistry getComponentFactoryRegistry() {
        ComponentFactoryRegistryAccessor cfra = (ComponentFactoryRegistryAccessor)this.getApplication();
        return cfra.getComponentFactoryRegistry();
    }
}

