/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages;

import org.apache.isis.applib.services.iactnlayer.InteractionService;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.core.config.environment.IsisSystemEnvironment;
import org.apache.isis.core.config.viewer.web.WebAppContextPath;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.wicket.model.util.CommonContextUtils;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.MetaDataHeaderItem;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public abstract class WebPageBase
extends WebPage
implements IsisAppCommonContext.HasCommonContext {
    private static final long serialVersionUID = 1L;
    private transient WebAppContextPath webAppContextPath;
    private transient PageClassRegistry pageClassRegistry;
    private transient IsisAppCommonContext commonContext;
    private transient InteractionService interactionService;

    protected WebPageBase(PageParameters parameters) {
        super(parameters);
    }

    protected WebPageBase(IModel<?> model) {
        super(model);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        this.renderFavicon(response);
    }

    protected void renderFavicon(IHeaderResponse response) {
        this.getConfiguration().getViewer().getWicket().getApplication().getFaviconUrl().filter(_Strings::isNotEmpty).map(arg_0 -> ((WebAppContextPath)this.getWebAppContextPath()).prependContextPathIfLocal(arg_0)).ifPresent(faviconUrl -> response.render((HeaderItem)MetaDataHeaderItem.forLinkTag((String)"icon", (String)faviconUrl)));
    }

    public IsisAppCommonContext getCommonContext() {
        this.commonContext = CommonContextUtils.computeIfAbsent((IsisAppCommonContext)this.commonContext);
        return this.commonContext;
    }

    public IsisConfiguration getConfiguration() {
        return this.getCommonContext().getConfiguration();
    }

    public WebAppContextPath getWebAppContextPath() {
        this.webAppContextPath = this.computeIfAbsent(WebAppContextPath.class, this.webAppContextPath);
        return this.webAppContextPath;
    }

    public PageClassRegistry getPageClassRegistry() {
        this.pageClassRegistry = this.computeIfAbsent(PageClassRegistry.class, this.pageClassRegistry);
        return this.pageClassRegistry;
    }

    public InteractionService getInteractionService() {
        this.interactionService = this.computeIfAbsent(InteractionService.class, this.interactionService);
        return this.interactionService;
    }

    public IsisSystemEnvironment getSystemEnvironment() {
        return this.getCommonContext().getSystemEnvironment();
    }

    private <X> X computeIfAbsent(Class<X> type, X existingIfAny) {
        return (X)(existingIfAny != null ? existingIfAny : this.getCommonContext().lookupServiceElseFail(type));
    }
}

