/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.accmngt.signup;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import java.io.Serializable;
import java.util.HashMap;
import javax.inject.Inject;
import org.apache.isis.applib.services.userreg.EmailNotificationService;
import org.apache.isis.applib.services.userreg.events.EmailRegistrationEvent;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.pages.EmailVerificationUrlService;
import org.apache.isis.viewer.wicket.ui.pages.PageNavigationService;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.EmailAvailableValidator;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.SuccessFeedbackCookieManager;
import org.apache.isis.viewer.wicket.ui.panels.PanelBase;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.EmailAddressValidator;

public class RegistrationFormPanel
extends PanelBase<Void> {
    private static final long serialVersionUID = 1L;
    @Inject
    private transient EmailNotificationService emailNotificationService;
    @Inject
    private transient EmailVerificationUrlService emailVerificationUrlService;
    @Inject
    private transient PageNavigationService pageNavigationService;

    public RegistrationFormPanel(String id) {
        super(id);
        this.addOrReplace(new Component[]{new NotificationPanel("feedback")});
        StatelessForm form = new StatelessForm("signUpForm");
        this.addOrReplace(new Component[]{form});
        final RequiredTextField emailField = new RequiredTextField("email", (IModel)Model.of((Serializable)((Object)"")));
        emailField.setLabel((IModel)new ResourceModel("emailLabel"));
        emailField.add((IValidator)EmailAddressValidator.getInstance());
        emailField.add((IValidator)EmailAvailableValidator.doesntExist(this.getCommonContext()));
        FormGroup formGroup = new FormGroup("formGroup", (FormComponent<?>)emailField);
        form.add(new Component[]{formGroup});
        formGroup.add(new Component[]{emailField});
        Button signUpButton = new Button("signUp"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                super.onSubmit();
                String email = (String)emailField.getModelObject();
                String confirmationUrl = RegistrationFormPanel.this.emailVerificationUrlService.createVerificationUrl(PageType.SIGN_UP_VERIFY, email);
                EmailRegistrationEvent emailRegistrationEvent = new EmailRegistrationEvent(email, confirmationUrl, RegistrationFormPanel.this.getIsisConfiguration().getViewer().getWicket().getApplication().getName());
                boolean emailSent = RegistrationFormPanel.this.emailNotificationService.send(emailRegistrationEvent);
                if (emailSent) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("email", email);
                    String emailSentMessage = this.getString("emailSentMessage", Model.ofMap(map));
                    SuccessFeedbackCookieManager.storeSuccessFeedback(emailSentMessage);
                    RegistrationFormPanel.this.pageNavigationService.navigateTo(PageType.SIGN_IN);
                }
            }
        };
        form.add(new Component[]{signUpButton});
    }
}

