/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.entity;

import java.util.Optional;
import java.util.UUID;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.commons.internal.base._Refs;
import org.apache.isis.commons.internal.base._Timing;
import org.apache.isis.commons.internal.debug._Debug;
import org.apache.isis.commons.internal.debug.xray.XrayUi;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.object.grid.GridFacet;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.modelhelpers.WhereAmIHelper;
import org.apache.isis.viewer.wicket.model.models.BookmarkableModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ObjectAdapterModel;
import org.apache.isis.viewer.wicket.model.util.PageParameterUtils;
import org.apache.isis.viewer.wicket.ui.components.entity.icontitle.EntityIconAndTitlePanel;
import org.apache.isis.viewer.wicket.ui.pages.PageAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

@AuthorizeInstantiation(value={"org.apache.isis.security.AUTHORIZED_USER_ROLE"})
public class EntityPage
extends PageAbstract {
    private static final long serialVersionUID = 144368606134796079L;
    private static final CssResourceReference ENTITY_PAGE_CSS = new CssResourceReference(EntityPage.class, "EntityPage.css");
    private final EntityModel model;
    private transient _Refs.ObjectReference<UUID> interactionId;

    public static EntityPage forPageParameters(IsisAppCommonContext commonContext, PageParameters pageParameters) {
        _Debug.onCondition((boolean)XrayUi.isXrayEnabled(), () -> _Debug.log((String)"new EntityPage from PageParameters %s", (Object[])new Object[]{pageParameters}));
        Optional bookmark = PageParameterUtils.toBookmark((PageParameters)pageParameters);
        if (!bookmark.isPresent()) {
            throw new RestartResponseException(Application.get().getHomePage());
        }
        return new EntityPage(pageParameters, EntityModel.ofPageParameters((IsisAppCommonContext)commonContext, (PageParameters)pageParameters));
    }

    public static EntityPage forAdapter(IsisAppCommonContext commonContext, ManagedObject adapter) {
        _Debug.onCondition((boolean)XrayUi.isXrayEnabled(), () -> _Debug.log((String)"new EntityPage from Adapter %s", (Object[])new Object[]{adapter.getSpecification()}));
        return new EntityPage(PageParameterUtils.createPageParametersForObject((ManagedObject)adapter), EntityModel.ofAdapter((IsisAppCommonContext)commonContext, (ManagedObject)adapter));
    }

    private EntityPage(PageParameters pageParameters, EntityModel entityModel) {
        super(pageParameters, null, ComponentType.ENTITY);
        this.model = entityModel;
        this.isAlreadyRefreshedWithinThisInteraction();
    }

    protected void onInitialize() {
        this.buildPage();
        super.onInitialize();
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)ENTITY_PAGE_CSS));
    }

    public void renderPage() {
        if (XrayUi.isXrayEnabled()) {
            _Debug.log((String)"about to render EntityPage ..", (Object[])new Object[0]);
            _Timing.StopWatch stopWatch = _Timing.now();
            EntityPage.viewmodelRefresh((IRequestablePage)this);
            super.renderPage();
            stopWatch.stop();
            _Debug.log((String)".. rendering took %s", (Object[])new Object[]{stopWatch.toString()});
        } else {
            EntityPage.viewmodelRefresh((IRequestablePage)this);
            super.renderPage();
        }
    }

    @Override
    public UiHintContainer getUiHintContainerIfAny() {
        return this.model;
    }

    private void buildPage() {
        ManagedObject objectAdapter;
        try {
            objectAdapter = (ManagedObject)this.model.getObject();
        }
        catch (RuntimeException ex) {
            this.removeAnyBookmark(this.model);
            this.removeAnyBreadcrumb(this.model);
            throw new ObjectMember.AuthorizationException(ex);
        }
        if (!this.model.isVisible()) {
            throw new ObjectMember.AuthorizationException();
        }
        ObjectSpecification objectSpec = this.model.getTypeOfSpecification();
        GridFacet gridFacet = (GridFacet)objectSpec.getFacet(GridFacet.class);
        if (gridFacet != null) {
            gridFacet.getGrid(objectAdapter);
        }
        String titleStr = objectAdapter.titleString();
        this.setTitle(titleStr);
        WebMarkupContainer entityPageContainer = new WebMarkupContainer("entityPageContainer");
        Wkt.cssAppend(entityPageContainer, objectSpec.getFeatureIdentifier());
        CssClassFacet cssClassFacet = (CssClassFacet)objectSpec.getFacet(CssClassFacet.class);
        if (cssClassFacet != null) {
            String cssClass = cssClassFacet.cssClass(objectAdapter);
            Wkt.cssAppend(entityPageContainer, cssClass);
        }
        this.themeDiv.addOrReplace(new Component[]{entityPageContainer});
        this.addWhereAmIIfShown(entityPageContainer, WhereAmIHelper.of((EntityModel)this.model));
        this.addChildComponents((MarkupContainer)entityPageContainer, (IModel<?>)this.model);
        this.bookmarkPageIfShown((BookmarkableModel)this.model);
        this.addBreadcrumbIfShown(this.model);
        this.addBookmarkedPages((MarkupContainer)entityPageContainer);
    }

    protected void addWhereAmIIfShown(WebMarkupContainer entityPageContainer, WhereAmIHelper whereAmIModel) {
        WebMarkupContainer whereAmIContainer = new WebMarkupContainer("whereAmI-container");
        entityPageContainer.addOrReplace(new Component[]{whereAmIContainer});
        if (!whereAmIModel.isShowWhereAmI()) {
            whereAmIContainer.setVisible(false);
            return;
        }
        RepeatingView listItems = new RepeatingView("whereAmI-items");
        whereAmIModel.streamParentChainReversed().forEach(entityModel -> listItems.add(new Component[]{new EntityIconAndTitlePanel(listItems.newChildId(), (ObjectAdapterModel)entityModel)}));
        Wkt.labelAdd((MarkupContainer)listItems, listItems.newChildId(), whereAmIModel.getStartOfChain().getTitle());
        whereAmIContainer.addOrReplace(new Component[]{listItems});
    }

    public static void viewmodelRefresh(IRequestablePage iRequestablePage) {
        if (iRequestablePage instanceof EntityPage) {
            ViewModelFacet viewModelFacet;
            EntityPage entityPage = (EntityPage)iRequestablePage;
            if (entityPage.isAlreadyRefreshedWithinThisInteraction()) {
                return;
            }
            EntityModel entityModel = (EntityModel)entityPage.getUiHintContainerIfAny();
            ObjectSpecification spec = ((ManagedObject)entityModel.getObject()).getSpecification();
            if (spec.isViewModel() && (viewModelFacet = (ViewModelFacet)spec.getFacet(ViewModelFacet.class)).containsEntities()) {
                _Debug.onCondition((boolean)XrayUi.isXrayEnabled(), () -> _Debug.log((String)"about to refresh EntityPage ..", (Object[])new Object[0]));
                ManagedObject viewmodel = entityModel.getBookmarkedOwner();
                if (viewmodel.isBookmarkMemoized()) {
                    viewmodel.reloadViewmodelFromMemoizedBookmark();
                } else {
                    Bookmark bookmark = (Bookmark)PageParameterUtils.toBookmark((PageParameters)entityPage.getPageParameters()).orElseThrow();
                    viewmodel.reloadViewmodelFromBookmark(bookmark);
                }
            }
        }
    }

    private _Refs.ObjectReference<UUID> interactionIdRef() {
        if (this.interactionId == null) {
            this.interactionId = _Refs.objectRef(null);
        }
        return this.interactionId;
    }

    private boolean isAlreadyRefreshedWithinThisInteraction() {
        UUID currentInteractionId = (UUID)this.getCommonContext().getInteractionProvider().getInteractionId().orElseThrow();
        Boolean alreadyRefreshedForThisInteraction = this.interactionIdRef().getValue().map(currentInteractionId::equals).orElse(false);
        if (alreadyRefreshedForThisInteraction.booleanValue()) {
            return true;
        }
        this.interactionIdRef().setValue((Object)currentInteractionId);
        return false;
    }

    private void addBreadcrumbIfShown(EntityModel entityModel) {
        this.getBreadcrumbModel().ifPresent(breadcrumbModel -> breadcrumbModel.visited(entityModel));
    }

    private void removeAnyBreadcrumb(EntityModel entityModel) {
        this.getBreadcrumbModel().ifPresent(breadcrumbModel -> breadcrumbModel.remove(entityModel));
    }
}

