/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.login;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import javax.inject.Inject;
import org.apache.isis.applib.services.iactnlayer.InteractionService;
import org.apache.isis.applib.services.inject.ServiceInjector;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.applib.services.userreg.EmailNotificationService;
import org.apache.isis.applib.services.userreg.UserRegistrationService;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.login.SignInPanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;

public class IsisSignInPanel
extends SignInPanelAbstract {
    private static final long serialVersionUID = 1L;
    @Inject
    transient InteractionService interactionService;
    @Inject
    transient ServiceInjector serviceInjector;
    @Inject
    transient ServiceRegistry serviceRegistry;
    @Inject
    private transient PageClassRegistry pageClassRegistry;
    transient Can<UserRegistrationService> anyUserRegistrationService;
    transient Can<EmailNotificationService> anyEmailNotificationService;
    private final boolean signUpLink;
    private final boolean passwordResetLink;
    private final boolean clearOriginalDestination;

    public IsisSignInPanel(String id, boolean rememberMe, boolean signUpLink, boolean passwordResetLink, boolean continueToOriginalDestination) {
        super(id, rememberMe);
        this.signUpLink = signUpLink;
        this.passwordResetLink = passwordResetLink;
        this.clearOriginalDestination = !continueToOriginalDestination;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.anyUserRegistrationService = this.serviceRegistry.select(UserRegistrationService.class);
        this.anyEmailNotificationService = this.serviceRegistry.select(EmailNotificationService.class);
        this.addOrReplace(new Component[]{new NotificationPanel("feedback")});
        BookmarkablePageLink<Void> passwordResetLink = this.addPasswordResetLink();
        BookmarkablePageLink<Void> signUpLink = this.addSignUpLink();
        this.setVisibilityAllowedBasedOnAvailableServices(new Component[]{signUpLink, passwordResetLink});
    }

    private BookmarkablePageLink<Void> addPasswordResetLink() {
        return this.addLink("passwdResetLink", PageType.PASSWORD_RESET, this.passwordResetLink);
    }

    private BookmarkablePageLink<Void> addSignUpLink() {
        return this.addLink("signUpLink", PageType.SIGN_UP, this.signUpLink);
    }

    private BookmarkablePageLink<Void> addLink(String id, PageType pageType, boolean visibilityAllowed) {
        BookmarkablePageLink link;
        if (this.pageClassRegistry != null) {
            Class<? extends Page> signUpPageClass = this.pageClassRegistry.getPageClass(pageType);
            link = new BookmarkablePageLink(id, signUpPageClass);
            if (!visibilityAllowed) {
                link.setVisibilityAllowed(false);
            }
        } else {
            link = new BookmarkablePageLink(id, null);
            link.setVisibilityAllowed(false);
        }
        this.getSignInFormWithTimeZone().addOrReplace(new Component[]{link});
        return link;
    }

    private void setVisibilityAllowedBasedOnAvailableServices(Component ... components) {
        boolean hasUserRegistrationService = this.anyUserRegistrationService.isNotEmpty();
        boolean hasConfiguredEmailNotificationService = this.anyEmailNotificationService.stream().anyMatch(EmailNotificationService::isConfigured);
        boolean visibilityAllowed = hasUserRegistrationService && hasConfiguredEmailNotificationService;
        for (Component component : components) {
            if (!component.isVisibilityAllowed()) continue;
            component.setVisibilityAllowed(visibilityAllowed);
        }
    }

    @Override
    protected void onSignInSucceeded() {
        if (this.clearOriginalDestination) {
            this.clearOriginalDestination();
        }
        super.onSignInSucceeded();
    }

    @Override
    protected void onSignInRemembered() {
        if (this.clearOriginalDestination) {
            this.clearOriginalDestination();
        }
        super.onSignInRemembered();
    }
}

