/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.login;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.wicket.model.util.CommonContextUtils;
import org.apache.wicket.Component;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class SignInPanelAbstract
extends Panel
implements IsisAppCommonContext.HasCommonContext {
    private static final long serialVersionUID = 1L;
    private static final String SIGN_IN_FORM = "signInForm";
    private static final String TIME_ZONE_SELECT = "timezone-select";
    private boolean includeRememberMe = true;
    private boolean rememberMe = true;
    private String password;
    private String username;
    private ZoneId timezone;
    private transient IsisAppCommonContext commonContext;
    private static final AtomicReference<Object> jsForTimezoneSelectDefault = new AtomicReference();

    public IsisAppCommonContext getCommonContext() {
        this.commonContext = CommonContextUtils.computeIfAbsent((IsisAppCommonContext)this.commonContext);
        return this.commonContext;
    }

    protected SignInPanelAbstract(String id, boolean includeRememberMe) {
        super(id);
        this.includeRememberMe = includeRememberMe;
        this.add(new Component[]{new FeedbackPanel("feedback")});
        this.add(new Component[]{new SignInFormWithTimeZone(SIGN_IN_FORM)});
    }

    protected SignInFormWithTimeZone getSignInFormWithTimeZone() {
        return (SignInFormWithTimeZone)this.get(SIGN_IN_FORM);
    }

    protected void onConfigure() {
        IAuthenticationStrategy authenticationStrategy;
        String[] data;
        if (!this.isSignedIn() && (data = (authenticationStrategy = this.getApplication().getSecuritySettings().getAuthenticationStrategy()).load()) != null && data.length > 1) {
            if (this.signIn(data[0], data[1])) {
                this.username = data[0];
                this.password = data[1];
                if (data.length > 2 && _Strings.isNotEmpty((CharSequence)data[2])) {
                    try {
                        this.timezone = ZoneId.of(data[2]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.onSignInRemembered();
            } else {
                authenticationStrategy.remove();
            }
        }
        super.onConfigure();
    }

    private boolean signIn(String username, String password) {
        return AuthenticatedWebSession.get().signIn(username, password);
    }

    private boolean isSignedIn() {
        return AuthenticatedWebSession.get().isSignedIn();
    }

    protected void onSignInFailed() {
        this.error((Serializable)((Object)this.getLocalizer().getString("signInFailed", (Component)this, "Sign in failed")));
    }

    protected void onSignInSucceeded() {
        this.continueToOriginalDestination();
        this.setResponsePage(this.getApplication().getHomePage());
    }

    protected void onSignInRemembered() {
        this.continueToOriginalDestination();
        throw new RestartResponseException(this.getApplication().getHomePage());
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public ZoneId getTimezone() {
        return this.timezone;
    }

    public void setTimezone(ZoneId timezone) {
        this.timezone = timezone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceReference getJsForTimezoneSelectDefault() {
        Object value = jsForTimezoneSelectDefault.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = jsForTimezoneSelectDefault;
            synchronized (atomicReference) {
                value = jsForTimezoneSelectDefault.get();
                if (value == null) {
                    JavaScriptResourceReference actualValue = new JavaScriptResourceReference(SignInPanelAbstract.class, "js/client-side-timezone-select.js");
                    value = actualValue == null ? jsForTimezoneSelectDefault : actualValue;
                    jsForTimezoneSelectDefault.set(value);
                }
            }
        }
        return (ResourceReference)(value == jsForTimezoneSelectDefault ? null : value);
    }

    public final class SignInFormWithTimeZone
    extends StatelessForm<SignInPanelAbstract> {
        private static final long serialVersionUID = 1L;

        public SignInFormWithTimeZone(String id) {
            super(id);
            CompoundPropertyModel propertyModel = new CompoundPropertyModel((Object)SignInPanelAbstract.this);
            this.setModel((IModel)propertyModel);
            this.add(new Component[]{new TextField("username").setRequired(true)});
            this.add(new Component[]{new PasswordTextField("password")});
            this.add(new Component[]{new DropDownChoice("timezone", (IModel)new PropertyModel((Object)SignInPanelAbstract.this, "timezone"), (IModel)new LoadableDetachableModel<List<ZoneId>>(){
                private static final long serialVersionUID = 1L;

                protected List<ZoneId> load() {
                    return ZoneId.getAvailableZoneIds().stream().sorted().map(ZoneId::of).collect(Collectors.toList());
                }
            }).setRequired(true).setMarkupId(SignInPanelAbstract.TIME_ZONE_SELECT)});
            WebMarkupContainer rememberMeContainer = new WebMarkupContainer("rememberMeContainer");
            this.add(new Component[]{rememberMeContainer});
            rememberMeContainer.add(new Component[]{new CheckBox("rememberMe")});
            rememberMeContainer.setVisible(SignInPanelAbstract.this.includeRememberMe);
        }

        public final void onSubmit() {
            IAuthenticationStrategy strategy = this.getApplication().getSecuritySettings().getAuthenticationStrategy();
            if (SignInPanelAbstract.this.signIn(SignInPanelAbstract.this.getUsername(), SignInPanelAbstract.this.getPassword())) {
                if (SignInPanelAbstract.this.rememberMe) {
                    strategy.save(SignInPanelAbstract.this.username, new String[]{SignInPanelAbstract.this.password, SignInPanelAbstract.this.timezone != null ? SignInPanelAbstract.this.timezone.getId() : ""});
                } else {
                    strategy.remove();
                }
                SignInPanelAbstract.this.onSignInSucceeded();
            } else {
                SignInPanelAbstract.this.onSignInFailed();
                strategy.remove();
            }
        }
    }
}

