/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.value;

import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ValueModel;
import org.apache.isis.viewer.wicket.model.util.PageParameterUtils;
import org.apache.isis.viewer.wicket.ui.pages.PageAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.model.IModel;

@AuthorizeInstantiation(value={"org.apache.isis.security.AUTHORIZED_USER_ROLE"})
public class ValuePage
extends PageAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_ACTION_NAME = "actionName";

    public ValuePage(ValueModel valueModel) {
        this(valueModel, ValuePage.actionNameFrom(valueModel));
    }

    private ValuePage(ValueModel valueModel, String actionName) {
        super(PageParameterUtils.newPageParameters(), actionName, ComponentType.VALUE);
        Wkt.labelAdd(this.themeDiv, ID_ACTION_NAME, actionName);
        this.addChildComponents(this.themeDiv, (IModel<?>)valueModel);
        this.addBookmarkedPages(this.themeDiv);
    }

    private static String actionNameFrom(ValueModel valueModel) {
        ActionModel actionModel = valueModel.getActionModelHint();
        if (actionModel != null) {
            return actionModel.getFriendlyName();
        }
        return "Results";
    }
}

