/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.voidreturn;

import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.VoidModel;
import org.apache.isis.viewer.wicket.model.util.PageParameterUtils;
import org.apache.isis.viewer.wicket.ui.pages.PageAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.model.IModel;

@AuthorizeInstantiation(value={"org.apache.isis.security.AUTHORIZED_USER_ROLE"})
public class VoidReturnPage
extends PageAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_ACTION_NAME = "actionName";

    public VoidReturnPage(VoidModel model) {
        this(model, VoidReturnPage.actionNameFrom(model));
    }

    private VoidReturnPage(VoidModel model, String actionName) {
        super(PageParameterUtils.newPageParameters(), actionName, ComponentType.VOID_RETURN);
        Wkt.labelAdd(this.themeDiv, ID_ACTION_NAME, actionName);
        this.addChildComponents(this.themeDiv, (IModel<?>)model);
        this.addBookmarkedPages(this.themeDiv);
    }

    private static String actionNameFrom(VoidModel model) {
        ActionModel actionModel = model.getActionModelHint();
        if (actionModel != null) {
            return actionModel.getFriendlyName();
        }
        return "Results";
    }
}

