/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.panels;

import java.io.Serializable;
import java.util.Optional;
import lombok.NonNull;
import org.apache.isis.applib.services.exceprecog.Category;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerService;
import org.apache.isis.applib.services.exceprecog.Recognition;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.applib.services.message.MessageService;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.base._Either;
import org.apache.isis.commons.internal.debug._Debug;
import org.apache.isis.commons.internal.debug.xray.XrayUi;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.FormExecutor;
import org.apache.isis.viewer.wicket.model.models.FormExecutorContext;
import org.apache.isis.viewer.wicket.model.models.ScalarParameterModel;
import org.apache.isis.viewer.wicket.model.models.ScalarPropertyModel;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponse;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponseType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.springframework.lang.Nullable;

public final class FormExecutorDefault
implements FormExecutor {
    private static final Logger log = LogManager.getLogger(FormExecutorDefault.class);
    private static final long serialVersionUID = 1L;
    protected final WicketViewerSettings settings;
    private final _Either<ActionModel, ScalarPropertyModel> actionOrPropertyModel;

    public static FormExecutor forAction(ActionModel actionModel) {
        return new FormExecutorDefault((_Either<ActionModel, ScalarPropertyModel>)_Either.left((Object)actionModel));
    }

    public static FormExecutor forProperty(ScalarPropertyModel propertyModel) {
        return new FormExecutorDefault((_Either<ActionModel, ScalarPropertyModel>)_Either.right((Object)propertyModel));
    }

    public static FormExecutor forMember(_Either<ActionModel, ScalarPropertyModel> actionOrPropertyModel) {
        return new FormExecutorDefault(actionOrPropertyModel);
    }

    private FormExecutorDefault(_Either<ActionModel, ScalarPropertyModel> actionOrPropertyModel) {
        this.actionOrPropertyModel = actionOrPropertyModel;
        this.settings = this.getSettings();
    }

    public FormExecutor.FormExecutionOutcome executeAndProcessResults(AjaxRequestTarget ajaxTarget, Form<?> feedbackFormIfAny, FormExecutorContext formExecutorContext) {
        try {
            _Debug.onCondition((boolean)XrayUi.isXrayEnabled(), () -> _Debug.log((String)"[EXECUTOR] start ...", (Object[])new Object[0]));
            Optional invalidReasonIfAny = Recognition.of((Category)Category.CONSTRAINT_VIOLATION, (String)((String)this.actionOrPropertyModel.fold(act -> act.getValidityConsent().getReason(), prop -> prop.getReasonInvalidIfAny())));
            if (invalidReasonIfAny.isPresent()) {
                this.raiseWarning(ajaxTarget, feedbackFormIfAny, (Recognition)invalidReasonIfAny.get());
                return FormExecutor.FormExecutionOutcome.FAILURE_RECOVERABLE_SO_STAY_ON_PAGE;
            }
            _Debug.onCondition((boolean)XrayUi.isXrayEnabled(), () -> {
                String whatIsExecuted = (String)this.actionOrPropertyModel.fold(act -> act.getFriendlyName(), prop -> prop.getFriendlyName());
                _Debug.log((String)"[EXECUTOR] execute %s ...", (Object[])new Object[]{whatIsExecuted});
            });
            ManagedObject resultAdapter = (ManagedObject)this.actionOrPropertyModel.fold(act -> act.executeActionAndReturnResult(), prop -> prop.applyValueThenReturnOwner());
            _Debug.onCondition((boolean)XrayUi.isXrayEnabled(), () -> {
                String whatIsExecuted = (String)this.actionOrPropertyModel.fold(act -> act.getFriendlyName(), prop -> prop.getFriendlyName());
                _Debug.log((String)"[EXECUTOR] resultAdapter created for %s", (Object[])new Object[]{whatIsExecuted});
            });
            if (formExecutorContext.getAssociatedParameter().isPresent()) {
                ((ScalarParameterModel)formExecutorContext.getAssociatedParameter().get()).setValue(resultAdapter);
                return FormExecutor.FormExecutionOutcome.SUCCESS_IN_NESTED_CONTEXT_SO_STAY_ON_PAGE;
            }
            if (log.isDebugEnabled()) {
                log.debug("about to redirect with {} after execution result {}", (Object)ManagedObjects.EntityUtil.getEntityState((ManagedObject)resultAdapter), (Object)resultAdapter);
            }
            _Debug.onCondition((boolean)XrayUi.isXrayEnabled(), () -> _Debug.log((String)"[EXECUTOR] interpret result ...", (Object[])new Object[0]));
            ActionResultResponse resultResponse = (ActionResultResponse)this.actionOrPropertyModel.fold(act -> ActionResultResponseType.determineAndInterpretResult(act, ajaxTarget, resultAdapter, (Can<ManagedObject>)act.snapshotArgs()), prop -> ActionResultResponseType.toEntityPage(resultAdapter));
            _Debug.onCondition((boolean)XrayUi.isXrayEnabled(), () -> _Debug.log((String)"[EXECUTOR] handle result ...", (Object[])new Object[0]));
            resultResponse.getHandlingStrategy().handleResults(this.getCommonContext(), resultResponse);
            _Debug.onCondition((boolean)XrayUi.isXrayEnabled(), () -> _Debug.log((String)"[EXECUTOR] ... return", (Object[])new Object[0]));
            return FormExecutor.FormExecutionOutcome.SUCCESS_AND_REDIRECED_TO_RESULT_PAGE;
        }
        catch (Throwable ex) {
            if (!formExecutorContext.isWithinInlinePrompt() && this.recognizeExceptionThenRaise(ex, ajaxTarget, feedbackFormIfAny).isPresent()) {
                return FormExecutor.FormExecutionOutcome.FAILURE_RECOVERABLE_SO_STAY_ON_PAGE;
            }
            throw ex;
        }
    }

    private Optional<Recognition> recognizeExceptionThenRaise(Throwable ex, AjaxRequestTarget target, Form<?> feedbackForm) {
        Optional recognition = this.getExceptionRecognizerService().recognize(ex);
        recognition.ifPresent(recog -> this.raiseWarning(target, feedbackForm, (Recognition)recog));
        return recognition;
    }

    private void raiseWarning(@Nullable AjaxRequestTarget targetIfAny, @Nullable Form<?> feedbackFormIfAny, @NonNull Recognition recognition) {
        String errorMsg;
        if (recognition == null) {
            throw new NullPointerException("recognition is marked non-null but is null");
        }
        String string = errorMsg = recognition.getCategory() == Category.CONSTRAINT_VIOLATION ? recognition.toMessageNoCategory(this.getTranslationService()) : recognition.toMessage(this.getTranslationService());
        if (targetIfAny != null && feedbackFormIfAny != null) {
            targetIfAny.add(new Component[]{feedbackFormIfAny});
            feedbackFormIfAny.error((Serializable)((Object)errorMsg));
        } else {
            this.getMessageService().warnUser(errorMsg);
        }
    }

    private IsisAppCommonContext getCommonContext() {
        return (IsisAppCommonContext)this.actionOrPropertyModel.fold(act -> act.getCommonContext(), prop -> prop.getCommonContext());
    }

    private ExceptionRecognizerService getExceptionRecognizerService() {
        return (ExceptionRecognizerService)this.getServiceRegistry().lookupServiceElseFail(ExceptionRecognizerService.class);
    }

    private TranslationService getTranslationService() {
        return this.getCommonContext().getTranslationService();
    }

    private MessageService getMessageService() {
        return (MessageService)this.getServiceRegistry().lookupServiceElseFail(MessageService.class);
    }

    private ServiceRegistry getServiceRegistry() {
        return this.getCommonContext().getServiceRegistry();
    }

    private WicketViewerSettings getSettings() {
        return (WicketViewerSettings)this.getCommonContext().lookupServiceElseFail(WicketViewerSettings.class);
    }
}

