/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.panels;

import java.io.Serializable;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.components.widgets.formcomponent.FormFeedbackPanel;
import org.apache.isis.viewer.wicket.ui.errors.JGrowlBehaviour;
import org.apache.isis.viewer.wicket.ui.panels.FormAbstract;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;

public abstract class OkCancelForm<T extends IModel<ManagedObject>>
extends FormAbstract<ManagedObject> {
    private static final long serialVersionUID = 1L;
    private static final String ID_OK_BUTTON = "okButton";
    public static final String ID_CANCEL_BUTTON = "cancelButton";
    private static final String ID_FEEDBACK = "feedback";
    protected final WicketViewerSettings settings;
    protected final AjaxButton okButton;
    protected final AjaxButton cancelButton;

    protected OkCancelForm(String id, WicketViewerSettings settings, IModel<ManagedObject> model) {
        super(id, model);
        this.settings = settings;
        this.okButton = Wkt.buttonAddOk((MarkupContainer)this, ID_OK_BUTTON, (IModel<String>)new ResourceModel("okLabel"), settings, (SerializableBiConsumer<AjaxButton, AjaxRequestTarget>)((SerializableBiConsumer & Serializable)this::onOkSubmitted));
        this.cancelButton = Wkt.buttonAdd((MarkupContainer)this, ID_CANCEL_BUTTON, (IModel<String>)new ResourceModel("cancelLabel"), (SerializableBiConsumer<AjaxButton, AjaxRequestTarget>)(SerializableBiConsumer & Serializable)(button, target) -> this.onCancelSubmitted((AjaxRequestTarget)target));
        this.configureOkButton(this.okButton);
        this.configureCancelButton(this.cancelButton);
        this.setDefaultButton((IFormSubmittingComponent)this.okButton);
        Wkt.add((MarkupContainer)this, new FormFeedbackPanel(ID_FEEDBACK));
        this.setOutputMarkupId(true);
    }

    protected abstract void onOkSubmitted(AjaxButton var1, AjaxRequestTarget var2);

    protected abstract void onCancelSubmitted(AjaxRequestTarget var1);

    protected void configureOkButton(AjaxButton okButton) {
        okButton.add(new Behavior[]{new JGrowlBehaviour(super.getCommonContext())});
    }

    protected void configureCancelButton(AjaxButton cancelButton) {
        cancelButton.setDefaultFormProcessing(false);
    }

    protected final void appendDefaultButtonField() {
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        buffer.append("<div style=\"width:0px;height:0px;position:absolute;left:-100px;top:-100px;overflow:hidden\">");
        buffer.append("<input type=\"text\" tabindex=\"-1\" autocomplete=\"off\"/>");
        AjaxButton submittingComponent = this.defaultSubmittingComponent();
        buffer.append("<input type=\"submit\" tabindex=\"-1\" name=\"");
        buffer.append(this.defaultSubmittingComponent().getInputName());
        buffer.append("\" onclick=\" var b=document.getElementById('");
        buffer.append(submittingComponent.getMarkupId());
        buffer.append("'); if (b!=null&amp;&amp;b.onclick!=null&amp;&amp;typeof(b.onclick) != 'undefined') {  var r = Wicket.bind(b.onclick, b)(); if (r != false) b.click(); } else { b.click(); };  return false;\" ");
        buffer.append(" />");
        buffer.append("</div>");
        this.getResponse().write((CharSequence)buffer);
    }

    private AjaxButton defaultSubmittingComponent() {
        return this.okButton;
    }
}

