/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.panels;

import java.util.function.Supplier;
import org.apache.isis.applib.services.i18n.LanguageProvider;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.applib.services.iactnlayer.InteractionService;
import org.apache.isis.applib.services.userreg.EmailNotificationService;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.core.config.viewer.web.WebAppContextPath;
import org.apache.isis.core.interaction.session.MessageBroker;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.common.model.header.HeaderUiModel;
import org.apache.isis.viewer.common.model.header.HeaderUiModelProvider;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.models.ImageResourceCache;
import org.apache.isis.viewer.wicket.model.util.CommonContextUtils;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.components.tree.themes.TreeThemeProvider;
import org.apache.isis.viewer.wicket.ui.components.tree.themes.TreeThemeProviderDefault;
import org.apache.isis.viewer.wicket.ui.pages.EmailVerificationUrlService;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageNavigationService;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.springframework.lang.Nullable;

public class PanelBase<T>
extends GenericPanel<T>
implements IsisAppCommonContext.HasCommonContext {
    private static final long serialVersionUID = 1L;
    private transient WicketViewerSettings wicketViewerSettings;
    private transient WebAppContextPath webAppContextPath;
    private transient IsisConfiguration isisConfiguration;
    private transient PageClassRegistry pageClassRegistry;
    private transient ImageResourceCache imageCache;
    private transient MetaModelContext metaModelContext;
    private transient IsisAppCommonContext commonContext;
    private transient InteractionService interactionService;
    private transient TranslationService translationService;
    private transient LanguageProvider localeProvider;
    private transient TreeThemeProvider treeThemeProvider;
    private transient EmailNotificationService emailNotificationService;
    private transient EmailVerificationUrlService emailVerificationUrlService;
    private transient PageNavigationService pageNavigationService;
    private transient HeaderUiModelProvider headerUiModelProvider;

    protected PanelBase(String id) {
        this(id, null);
    }

    public PanelBase(String id, @Nullable IModel<T> model) {
        super(id, model);
    }

    public IsisAppCommonContext getCommonContext() {
        this.commonContext = CommonContextUtils.computeIfAbsent((IsisAppCommonContext)this.commonContext);
        return this.commonContext;
    }

    public WicketViewerSettings getWicketViewerSettings() {
        this.wicketViewerSettings = this.computeIfAbsent(WicketViewerSettings.class, this.wicketViewerSettings);
        return this.wicketViewerSettings;
    }

    public WebAppContextPath getWebAppContextPath() {
        this.webAppContextPath = this.computeIfAbsent(WebAppContextPath.class, this.webAppContextPath);
        return this.webAppContextPath;
    }

    public IsisConfiguration getIsisConfiguration() {
        this.isisConfiguration = this.computeIfAbsent(IsisConfiguration.class, this.isisConfiguration);
        return this.isisConfiguration;
    }

    public PageClassRegistry getPageClassRegistry() {
        this.pageClassRegistry = this.computeIfAbsent(PageClassRegistry.class, this.pageClassRegistry);
        return this.pageClassRegistry;
    }

    public ImageResourceCache getImageResourceCache() {
        this.imageCache = this.computeIfAbsent(ImageResourceCache.class, this.imageCache);
        return this.imageCache;
    }

    public MetaModelContext getMetaModelContext() {
        this.metaModelContext = this.computeIfAbsent(MetaModelContext.class, this.metaModelContext);
        return this.metaModelContext;
    }

    public InteractionService getInteractionService() {
        this.interactionService = this.computeIfAbsent(InteractionService.class, this.interactionService);
        return this.interactionService;
    }

    public TranslationService getTranslationService() {
        this.translationService = this.computeIfAbsent(TranslationService.class, this.translationService);
        return this.translationService;
    }

    public LanguageProvider getLanguageProvider() {
        this.localeProvider = this.computeIfAbsent(LanguageProvider.class, this.localeProvider);
        return this.localeProvider;
    }

    protected TreeThemeProvider getTreeThemeProvider() {
        this.treeThemeProvider = this.computeIfAbsentOrFallback(TreeThemeProvider.class, this.treeThemeProvider, TreeThemeProviderDefault::new);
        return this.treeThemeProvider;
    }

    protected EmailNotificationService getEmailNotificationService() {
        this.emailNotificationService = this.computeIfAbsent(EmailNotificationService.class, this.emailNotificationService);
        return this.emailNotificationService;
    }

    protected EmailVerificationUrlService getEmailVerificationUrlService() {
        this.emailVerificationUrlService = this.computeIfAbsent(EmailVerificationUrlService.class, this.emailVerificationUrlService);
        return this.emailVerificationUrlService;
    }

    protected PageNavigationService getPageNavigationService() {
        this.pageNavigationService = this.computeIfAbsent(PageNavigationService.class, this.pageNavigationService);
        return this.pageNavigationService;
    }

    protected MessageBroker getMessageBroker() {
        return (MessageBroker)this.getCommonContext().getMessageBroker().orElseThrow(() -> _Exceptions.illegalState((String)"no MessageBroker available on current session", (Object[])new Object[0]));
    }

    protected HeaderUiModel getHeaderModel() {
        this.headerUiModelProvider = this.computeIfAbsent(HeaderUiModelProvider.class, this.headerUiModelProvider);
        return this.headerUiModelProvider.getHeader();
    }

    public UiHintContainer getUiHintContainer() {
        return UiHintContainer.Util.hintContainerOf((Component)this);
    }

    protected ComponentFactoryRegistry getComponentFactoryRegistry() {
        return ((ComponentFactoryRegistryAccessor)this.getApplication()).getComponentFactoryRegistry();
    }

    private <X> X computeIfAbsent(Class<X> type, X existingIfAny) {
        return (X)(existingIfAny != null ? existingIfAny : this.getCommonContext().lookupServiceElseFail(type));
    }

    private <X> X computeIfAbsentOrFallback(Class<X> type, X existingIfAny, Supplier<X> fallback) {
        return (X)(existingIfAny != null ? existingIfAny : this.getCommonContext().lookupServiceElseFallback(type, fallback));
    }
}

