/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.panels;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.isis.commons.internal.base._Either;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.debug._Probe;
import org.apache.isis.commons.internal.functions._Functions;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.ActionPromptProvider;
import org.apache.isis.viewer.wicket.model.models.FormExecutor;
import org.apache.isis.viewer.wicket.model.models.FormExecutorContext;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ScalarPropertyModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarModelSubscriber;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.isis.viewer.wicket.ui.panels.FormExecutorDefault;
import org.apache.isis.viewer.wicket.ui.panels.OkCancelForm;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public abstract class PromptFormAbstract<T extends FormExecutorContext & IModel<ManagedObject>>
extends OkCancelForm<T>
implements ScalarModelSubscriber {
    private static final long serialVersionUID = 1L;
    protected final List<ScalarPanelAbstract> paramPanels = _Lists.newArrayList();
    private final Component parentPanel;

    protected PromptFormAbstract(String id, Component parentPanel, WicketViewerSettings settings, T model) {
        super(id, settings, (IModel<ManagedObject>)((IModel)model));
        this.parentPanel = parentPanel;
        this.addParameters();
    }

    private FormExecutorContext formExecutorContext() {
        return (FormExecutorContext)this.getModel();
    }

    protected abstract void addParameters();

    protected abstract _Either<ActionModel, ScalarPropertyModel> getMemberModel();

    protected abstract Object newCompletedEvent(AjaxRequestTarget var1, Form<?> var2);

    public final void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        Wkt.javaScriptAdd(response, Wkt.EventTopic.FOCUS_FIRST_PARAMETER, this.getMarkupId());
    }

    @Override
    protected final void configureCancelButton(AjaxButton cancelButton) {
        super.configureCancelButton(cancelButton);
        if (this.formExecutorContext().getPromptStyle().isInlineOrInlineAsIfEdit()) {
            Wkt.behaviorAddFireOnEscapeKey((MarkupContainer)cancelButton, (SerializableConsumer<AjaxRequestTarget>)((SerializableConsumer & Serializable)this::onCancelSubmitted));
        }
    }

    @Override
    protected final void onOkSubmitted(AjaxButton okButton, AjaxRequestTarget target) {
        _Probe.entryPoint((_Probe.EntryPoint)_Probe.EntryPoint.USER_INTERACTION, (String)"Wicket Ajax Request, originating from User clicking OK on an inline editing form or action prompt.");
        this.setLastFocusHint();
        Form form = okButton.getForm();
        FormExecutor formExecutor = FormExecutorDefault.forMember(this.getMemberModel());
        FormExecutor.FormExecutionOutcome outcome = formExecutor.executeAndProcessResults(target, form, this.formExecutorContext());
        if (outcome.isSuccess()) {
            this.completePrompt(target);
            okButton.send((IEventSink)target.getPage(), Broadcast.EXACT, this.newCompletedEvent(target, form));
            Components.addToAjaxRequest(target, (Component)form);
        }
    }

    @Override
    public final void onCancelSubmitted(AjaxRequestTarget target) {
        _Probe.entryPoint((_Probe.EntryPoint)_Probe.EntryPoint.USER_INTERACTION, (String)"Wicket Ajax Request, originating from User clicking CANCEL (or hitting ESC) on an inline editing form or action prompt.");
        this.setLastFocusHint();
        this.getMemberModel().accept(_Functions.noopConsumer(), prop -> {
            Component scalarContainer = prop.getInlinePromptContext().getScalarIfRegular();
            if (scalarContainer instanceof FormGroup) {
                FormComponent<?> scalarFormComponent = ((FormGroup)scalarContainer).getFormComponent();
                if (scalarFormComponent.getDefaultModel() instanceof ScalarModel) {
                    ManagedObject untouchedPropertyValue = prop.getManagedProperty().getPropertyValue();
                    scalarFormComponent.setDefaultModelObject((Object)untouchedPropertyValue);
                } else {
                    Object untouchedPropertyValue = ManagedObjects.UnwrapUtil.single((ManagedObject)prop.getManagedProperty().getPropertyValue());
                    scalarFormComponent.setDefaultModelObject(untouchedPropertyValue);
                }
            }
        });
        this.completePrompt(target);
    }

    @Override
    public final void onError(AjaxRequestTarget target, ScalarPanelAbstract scalarPanel) {
        if (scalarPanel != null) {
            target.add(new Component[]{scalarPanel});
        }
    }

    private void completePrompt(AjaxRequestTarget target) {
        if (this.formExecutorContext().isWithinInlinePrompt()) {
            this.rebuildGuiAfterInlinePromptDone(target);
        } else {
            this.closePromptIfAny(target);
        }
    }

    private void closePromptIfAny(AjaxRequestTarget target) {
        try {
            ActionPromptProvider.getFrom((Component)this.parentPanel).closePrompt(target);
        }
        catch (WicketRuntimeException wicketRuntimeException) {
            // empty catch block
        }
    }

    private void setLastFocusHint() {
        UiHintContainer entityModel = this.pageUiHintContainerIfAny();
        if (entityModel == null) {
            return;
        }
        MarkupContainer parentContainer = this.parentPanel.getParent();
        if (parentContainer != null) {
            entityModel.setHint((Component)this.getPage(), "focus", parentContainer.getPageRelativePath());
        }
    }

    private UiHintContainer pageUiHintContainerIfAny() {
        Page page;
        try {
            page = this.getPage();
        }
        catch (WicketRuntimeException ex) {
            return null;
        }
        if (page instanceof EntityPage) {
            EntityPage entityPage = (EntityPage)page;
            return entityPage.getUiHintContainerIfAny();
        }
        return null;
    }

    private void rebuildGuiAfterInlinePromptDone(AjaxRequestTarget target) {
        target.add(new Component[]{this.parentPanel.getParent()});
        Wkt.containerAdd(this.parentPanel.getParent(), this.parentPanel.getId()).setVisible(false);
        this.formExecutorContext().getInlinePromptContext().onCancel();
        Optional.ofNullable(this.formExecutorContext().getInlinePromptContext().getScalarTypeContainer()).ifPresent(scalarTypeContainer -> Wkt.javaScriptAdd(target, Wkt.EventTopic.FOCUS_FIRST_PROPERTY, scalarTypeContainer.getMarkupId()));
    }
}

